/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.nms;

import fr.skytasul.quests.utils.nms.NMS;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.lang.reflect.Field;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;

public class PaperNMS
extends NMS {
    private Field customTagField;

    public PaperNMS() throws NoSuchFieldException, SecurityException {
        this.customTagField = this.craftReflect.fromName("inventory.CraftMetaItem").getDeclaredField("customTag");
        this.customTagField.setAccessible(true);
    }

    @Override
    public List<String> getAvailableBlockProperties(Material material) {
        Registry blockRegistry = MinecraftServer.getServer().registryAccess().lookupOrThrow(Registries.BLOCK);
        Holder.Reference block = blockRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)material.getKey().toString())));
        StateDefinition stateList = ((Block)block.value()).getStateDefinition();
        return stateList.getProperties().stream().map(Property::getName).toList();
    }

    @Override
    public List<Key> getAvailableBlockTags() {
        return RegistryAccess.registryAccess().getRegistry(RegistryKey.BLOCK).getTags().stream().map(x -> x.tagKey().key()).toList();
    }

    @Override
    public boolean equalsWithoutNBT(ItemMeta meta1, ItemMeta meta2) throws ReflectiveOperationException {
        this.unhandledTags.set(meta1, DataComponentPatch.builder());
        this.unhandledTags.set(meta2, DataComponentPatch.builder());
        this.customTagField.set(meta1, null);
        this.customTagField.set(meta2, null);
        return (Boolean)this.equalsCommon.invoke((Object)meta1, meta2);
    }
}

