/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.types;

import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BQLocation
extends Location
implements Locatable.Located,
HasPlaceholders {
    @Nullable
    private Pattern worldPattern;
    @Nullable
    private PlaceholderRegistry placeholders;

    public BQLocation(World world, double x, double y, double z) {
        this(world, x, y, z, 0.0f, 0.0f);
    }

    public BQLocation(World world, double x, double y, double z, float yaw, float pitch) {
        super(world, x, y, z, yaw, pitch);
        if (world == null) {
            this.worldPattern = Pattern.compile(".*");
        }
    }

    public BQLocation(String worldPattern, double x, double y, double z) {
        this(worldPattern, x, y, z, 0.0f, 0.0f);
    }

    public BQLocation(String worldPattern, double x, double y, double z, float yaw, float pitch) {
        super(null, x, y, z, yaw, pitch);
        this.worldPattern = Pattern.compile(worldPattern);
    }

    public Pattern getWorldPattern() {
        return this.worldPattern;
    }

    public BQLocation setWorldPattern(Pattern worldPattern) {
        this.worldPattern = worldPattern;
        if (worldPattern != null) {
            super.setWorld(null);
        }
        return this;
    }

    public void setWorld(World world) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location getLocation() {
        return new Location((World)this.getMatchingWorld().orElse(null), this.getX(), this.getY(), this.getZ());
    }

    @Override
    public Locatable.LocatedType getType() {
        return Locatable.LocatedType.OTHER;
    }

    public boolean isWorld(World world) {
        Validate.notNull((Object)world);
        if (super.getWorld() != null) {
            return super.getWorld().equals((Object)world);
        }
        return this.worldPattern.matcher(world.getName()).matches();
    }

    public String getWorldName() {
        return this.getWorld() == null ? this.worldPattern.pattern() : this.getWorld().getName();
    }

    @NotNull
    public Optional<World> getMatchingWorld() {
        if (super.getWorld() != null) {
            return Optional.of(super.getWorld());
        }
        if (this.worldPattern == null) {
            return Optional.empty();
        }
        return Bukkit.getWorlds().stream().filter(world -> this.worldPattern.matcher(world.getName()).matches()).findFirst();
    }

    @Nullable
    public Block getMatchingBlock() {
        return this.getMatchingWorld().map(world -> world.getBlockAt(this.getBlockX(), this.getBlockY(), this.getBlockZ())).orElse(null);
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().register("x", () -> Integer.toString(this.getBlockX())).register("y", () -> Integer.toString(this.getBlockY())).register("z", () -> Integer.toString(this.getBlockZ())).register("world", () -> this.getWorldName()).register("world_name", () -> this.getWorld() == null ? null : this.getWorld().getName()).register("world_pattern", () -> this.worldPattern.pattern());
        }
        return this.placeholders;
    }

    public double distanceSquared(Location o) {
        Validate.isTrue((boolean)this.isWorld(o.getWorld()), (String)"World does not match");
        return NumberConversions.square((double)(this.getX() - o.getX())) + NumberConversions.square((double)(this.getY() - o.getY())) + NumberConversions.square((double)(this.getZ() - o.getZ()));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (Double.doubleToLongBits(this.getX()) != Double.doubleToLongBits(other.getX())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getY()) != Double.doubleToLongBits(other.getY())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getZ()) != Double.doubleToLongBits(other.getZ())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPitch()) != Float.floatToIntBits(other.getPitch())) {
            return false;
        }
        if (Float.floatToIntBits(this.getYaw()) != Float.floatToIntBits(other.getYaw())) {
            return false;
        }
        if (obj instanceof BQLocation) {
            BQLocation otherBQ = (BQLocation)obj;
            if (this.worldPattern == null) {
                return otherBQ.worldPattern == null;
            }
            if (otherBQ.worldPattern == null) {
                return false;
            }
            return this.worldPattern.pattern().equals(otherBQ.worldPattern.pattern());
        }
        if (!Objects.equals(other.getWorld(), this.getWorld())) {
            if (other.getWorld() == null) {
                return false;
            }
            if (this.worldPattern == null) {
                return false;
            }
            return this.worldPattern.matcher(other.getWorld().getName()).matches();
        }
        return true;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 19 * hash + (this.worldPattern == null ? 0 : this.worldPattern.pattern().hashCode());
        return hash;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getWorld() == null) {
            map.put("pattern", this.worldPattern.pattern());
        } else {
            map.put("world", this.getWorld().getName());
        }
        map.put("x", this.getX());
        map.put("y", this.getY());
        map.put("z", this.getZ());
        map.put("yaw", Float.valueOf(this.getYaw()));
        map.put("pitch", Float.valueOf(this.getPitch()));
        return map;
    }

    @NotNull
    public static BQLocation deserialize(@NotNull Map<String, Object> args) {
        double x = NumberConversions.toDouble((Object)args.get("x"));
        double y = NumberConversions.toDouble((Object)args.get("y"));
        double z = NumberConversions.toDouble((Object)args.get("z"));
        float yaw = NumberConversions.toFloat((Object)args.get("yaw"));
        float pitch = NumberConversions.toFloat((Object)args.get("pitch"));
        World world = null;
        String worldPattern = null;
        if (args.containsKey("world")) {
            String worldName = (String)args.get("world");
            world = Bukkit.getWorld((String)worldName);
            if (world == null) {
                worldPattern = Pattern.quote(worldName);
            }
        } else if (args.containsKey("pattern")) {
            worldPattern = (String)args.get("pattern");
        }
        if (worldPattern != null) {
            return new BQLocation(worldPattern, x, y, z, yaw, pitch);
        }
        return new BQLocation(world, x, y, z, yaw, pitch);
    }

    public static BQLocation of(Location location) {
        if (location instanceof BQLocation) {
            BQLocation bqLoc = (BQLocation)location;
            return new BQLocation(bqLoc.getWorldName(), bqLoc.getX(), bqLoc.getY(), bqLoc.getZ(), bqLoc.getYaw(), bqLoc.getPitch());
        }
        return new BQLocation(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }
}

