/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.types;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Command
implements HasPlaceholders {
    public final String label;
    public final boolean console;
    public final boolean parse;
    public final int delay;
    @Nullable
    private PlaceholderRegistry placeholders;

    public Command(String label, boolean console, boolean parse, int delay) {
        this.label = label;
        this.console = console;
        this.parse = parse;
        this.delay = delay;
    }

    public void execute(Player o) {
        Runnable run = () -> {
            String formattedCommand = MessageUtils.finalFormat(this.label, null, PlaceholdersContext.of(o, this.parse, null));
            ConsoleCommandSender sender = this.console ? Bukkit.getConsoleSender() : o;
            Bukkit.dispatchCommand((CommandSender)sender, (String)formattedCommand);
            QuestsPlugin.getPlugin().getLoggerExpanded().debug(sender.getName() + " performed command " + formattedCommand);
        };
        if (this.delay == 0 && Bukkit.isPrimaryThread()) {
            run.run();
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)BeautyQuests.getInstance(), run, (long)this.delay);
        }
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry().registerIndexed("command_label", this.label).registerIndexed("command_console", this.console ? Lang.Yes : Lang.No).register("command_parsed", this.parse ? Lang.Yes : Lang.No).register("command_delay", Lang.Ticks.quickFormat("ticks", this.delay));
        }
        return this.placeholders;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("label", this.label);
        map.put("console", this.console);
        if (this.parse) {
            map.put("parse", this.parse);
        }
        if (this.delay > 0) {
            map.put("delay", this.delay);
        }
        return map;
    }

    public static Command deserialize(Map<String, Object> map) {
        return new Command((String)map.get("label"), (Boolean)map.get("console"), (Boolean)map.getOrDefault("parse", Boolean.TRUE), (Integer)map.getOrDefault("delay", 0));
    }
}

