/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.types;

import fr.skytasul.quests.BeautyQuests;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import fr.skytasul.quests.api.npcs.dialogs.DialogRunner;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.npcs.dialogs.events.DialogSendEvent;
import fr.skytasul.quests.api.npcs.dialogs.events.DialogSendMessageEvent;
import fr.skytasul.quests.utils.DebugUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogRunnerImplementation
implements DialogRunner {
    @Nullable
    private final Dialog dialog;
    @Nullable
    private final BqNpc npc;
    private List<Predicate<Player>> tests = new ArrayList<Predicate<Player>>();
    private List<Predicate<Player>> testsCancelling = new ArrayList<Predicate<Player>>();
    private List<Consumer<Player>> endActions = new ArrayList<Consumer<Player>>();
    private Map<Player, PlayerStatus> players = new HashMap<Player, PlayerStatus>();
    private Boolean navigationInitiallyPaused = null;

    public DialogRunnerImplementation(@Nullable Dialog dialog, @Nullable BqNpc npc) {
        this.dialog = dialog;
        this.npc = npc;
    }

    @Override
    @Nullable
    public BqNpc getNpc() {
        return this.npc;
    }

    @Override
    @Nullable
    public Dialog getDialog() {
        return this.dialog;
    }

    @Override
    public void addTest(Predicate<Player> test) {
        this.tests.add(test);
    }

    @Override
    public void addTestCancelling(Predicate<Player> test) {
        this.testsCancelling.add(test);
    }

    @Override
    public void addEndAction(Consumer<Player> action) {
        this.endActions.add(action);
    }

    private DialogRunner.TestResult test(Player p) {
        if (!this.tests.stream().allMatch(x -> x.test(p))) {
            return DialogRunner.TestResult.DENY;
        }
        if (!this.testsCancelling.stream().allMatch(x -> x.test(p))) {
            return DialogRunner.TestResult.DENY_CANCEL;
        }
        return DialogRunner.TestResult.ALLOW;
    }

    @Override
    public boolean canContinue(Player p) {
        if (this.npc == null || QuestsConfiguration.getConfig().getDialogsConfig().getMaxDistance() == 0) {
            return true;
        }
        return p.getLocation().distanceSquared(this.npc.getLocation()) <= (double)QuestsConfiguration.getConfig().getDialogsConfig().getMaxDistanceSquared();
    }

    private void end(Player p) {
        if (this.test(p) != DialogRunner.TestResult.ALLOW) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Dialog predicates not completed for NPC " + this.npc.getId() + " whereas the dialog should end. This is a bug.");
            return;
        }
        this.endActions.forEach(x -> x.accept(p));
    }

    @Override
    public DialogRunner.TestResult onClick(Player p) {
        PlayerStatus status;
        if (QuestsConfiguration.getConfig().getDialogsConfig().isClickDisabled() && (status = this.players.get(p)) != null && status.task != null) {
            return DialogRunner.TestResult.DENY;
        }
        if (p.isSneaking() && this.dialog != null && this.dialog.isSkippable() && this.test(p) == DialogRunner.TestResult.ALLOW) {
            Lang.DIALOG_SKIPPED.send((CommandSender)p);
            this.removePlayer(p);
            this.end(p);
            return DialogRunner.TestResult.ALLOW;
        }
        return this.handleNext(p, DialogRunner.DialogNextReason.NPC_CLICK);
    }

    @Override
    public DialogRunner.TestResult handleNext(Player p, DialogRunner.DialogNextReason reason) {
        DialogRunner.TestResult test = this.test(p);
        if (test == DialogRunner.TestResult.ALLOW) {
            if (this.dialog == null || this.npc == null) {
                this.end(p);
                return DialogRunner.TestResult.ALLOW;
            }
            DialogSendEvent event = new DialogSendEvent(p, this);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return DialogRunner.TestResult.DENY_CANCEL;
            }
            PlayerStatus status = this.addPlayer(p);
            status.cancel();
            if (this.send(p, status, reason)) {
                this.removePlayer(p);
                this.end(p);
            } else {
                Message message = this.dialog.getMessages().get(status.lastId);
                if (message.getWaitTime() != 0) {
                    status.task = Bukkit.getScheduler().runTaskLater((Plugin)BeautyQuests.getInstance(), () -> {
                        status.task = null;
                        if (this.canContinue(p)) {
                            this.handleNext(p, DialogRunner.DialogNextReason.AUTO_TIME);
                        } else {
                            Lang.DIALOG_TOO_FAR.quickSend((CommandSender)p, "npc_name", (Object)this.dialog.getNPCName(this.npc));
                            this.removePlayer(p);
                        }
                    }, (long)message.getWaitTime());
                }
            }
            return DialogRunner.TestResult.ALLOW;
        }
        this.removePlayer(p);
        return test;
    }

    private boolean send(Player p, PlayerStatus status, DialogRunner.DialogNextReason reason) {
        int id;
        boolean endOfDialog;
        if (this.dialog.getMessages().isEmpty()) {
            return true;
        }
        boolean bl = endOfDialog = (id = ++status.lastId) == this.dialog.getMessages().size();
        if (status.runningMsg != null && !endOfDialog && reason != DialogRunner.DialogNextReason.AUTO_TIME) {
            status.runningMsg.stopSound(p);
        }
        if (endOfDialog) {
            return true;
        }
        Message msg = this.dialog.getMessages().get(id);
        if (msg == null) {
            p.sendMessage("\u00a7cMessage with ID " + id + " does not exist. Please report this to an adminstrator. Method caller: " + DebugUtils.stackTraces(2, 3));
            return true;
        }
        status.runningMsg = msg;
        DialogSendMessageEvent event = new DialogSendMessageEvent(p, this, msg);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            msg.playSound(p, this.npc.getEntity());
            QuestsAPI.getAPI().getMessageSender().displayMessage(p, this, msg);
        }
        return false;
    }

    @Override
    public boolean isPlayerInDialog(Player p) {
        return this.players.containsKey(p);
    }

    @Override
    public int getPlayerMessage(Player p) {
        return this.players.get((Object)p).lastId;
    }

    public PlayerStatus addPlayer(Player player) {
        PlayerStatus status = this.players.get(player);
        if (status != null) {
            return status;
        }
        status = new PlayerStatus();
        this.players.put(player, status);
        if (this.npc != null && this.navigationInitiallyPaused == null) {
            this.navigationInitiallyPaused = this.npc.getNpc().setNavigationPaused(true);
        }
        return status;
    }

    @Override
    public boolean removePlayer(Player player) {
        PlayerStatus status = this.players.remove(player);
        if (status == null) {
            return false;
        }
        status.cancel();
        QuestsAPI.getAPI().getMessageSender().stopDisplayingMessages(player, this);
        this.handlePlayerChanges();
        return true;
    }

    @Override
    public void forceFinish(@NotNull Player player) {
        this.end(player);
        this.removePlayer(player);
    }

    private void handlePlayerChanges() {
        if (this.players.isEmpty() && this.npc != null && this.navigationInitiallyPaused != null) {
            this.npc.getNpc().setNavigationPaused(this.navigationInitiallyPaused);
            this.navigationInitiallyPaused = null;
        }
    }

    public void unload() {
        if (!this.players.isEmpty()) {
            this.players.values().forEach(PlayerStatus::cancel);
        }
        this.players.clear();
        this.handlePlayerChanges();
    }

    class PlayerStatus {
        int lastId = -1;
        BukkitTask task = null;
        Message runningMsg = null;

        PlayerStatus() {
        }

        void cancel() {
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

