/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.utils.types;

import fr.skytasul.quests.api.localization.Lang;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.util.Ticks;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Title {
    public static final int FADE_IN = 10;
    public static final int STAY = 70;
    public static final int FADE_OUT = 20;
    public final String title;
    public final String subtitle;
    public final int fadeIn;
    public final int stay;
    public final int fadeOut;
    private final net.kyori.adventure.title.Title adventureTitle;

    public Title(String title, String subtitle) {
        this(title, subtitle, 10, 70, 20);
    }

    public Title(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.title = title;
        this.subtitle = subtitle;
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
        this.adventureTitle = net.kyori.adventure.title.Title.title((Component)this.deserializeText(title), (Component)this.deserializeText(subtitle), (Title.Times)Title.Times.of((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeOut)));
    }

    public Title(Title other) {
        this(other.title, other.subtitle, other.fadeIn, other.stay, other.fadeOut);
    }

    public void send(Audience audience) {
        audience.showTitle(this.adventureTitle);
    }

    @NotNull
    private Component deserializeText(@Nullable String string) {
        return LegacyComponentSerializer.legacySection().deserializeOr((Object)string, (Component)Component.empty());
    }

    public String toString() {
        return this.title + ", " + this.subtitle + ", " + Lang.Ticks.quickFormat("ticks", this.fadeIn + this.stay + this.fadeOut);
    }

    public void serialize(ConfigurationSection section) {
        if (this.title != null) {
            section.set("title", (Object)this.title);
        }
        if (this.subtitle != null) {
            section.set("subtitle", (Object)this.subtitle);
        }
        if (this.fadeIn != 10) {
            section.set("fadeIn", (Object)this.fadeIn);
        }
        if (this.stay != 70) {
            section.set("stay", (Object)this.stay);
        }
        if (this.fadeOut != 20) {
            section.set("fadeOut", (Object)this.fadeOut);
        }
    }

    public static Title deserialize(ConfigurationSection section) {
        String title = section.getString("title", null);
        String subtitle = section.getString("subtitle", null);
        int fadeIn = section.getInt("fadeIn", 10);
        int stay = section.getInt("stay", 70);
        int fadeOut = section.getInt("fadeOut", 20);
        return new Title(title, subtitle, fadeIn, stay, fadeOut);
    }
}

