/*
 * Decompiled with CFR 0.152.
 */
package me.nahu.scheduler.wrapper.implementation.folia;

import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.RegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import me.nahu.scheduler.wrapper.WrappedScheduler;
import me.nahu.scheduler.wrapper.implementation.folia.task.FoliaWrappedTask;
import me.nahu.scheduler.wrapper.task.WrappedTask;
import me.nahu.scheduler.wrapper.type.ImplementationType;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class FoliaWrappedScheduler
implements WrappedScheduler {
    private static final ImplementationType IMPLEMENTATION_TYPE = ImplementationType.FOLIA;
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private final Plugin plugin;
    private final GlobalRegionScheduler globalRegionScheduler;
    private final AsyncScheduler asyncScheduler;
    private final RegionScheduler regionScheduler;

    public FoliaWrappedScheduler(@NotNull Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null!");
        this.globalRegionScheduler = Bukkit.getGlobalRegionScheduler();
        this.asyncScheduler = Bukkit.getAsyncScheduler();
        this.regionScheduler = Bukkit.getRegionScheduler();
    }

    @Override
    @NotNull
    public ImplementationType getImplementationType() {
        return IMPLEMENTATION_TYPE;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void cancelAllTasks() {
        this.globalRegionScheduler.cancelTasks(this.plugin);
        this.asyncScheduler.cancelTasks(this.plugin);
    }

    @Override
    public void cancelTask(@NotNull WrappedTask wrappedTask) {
        wrappedTask.cancel();
    }

    @Override
    @NotNull
    public WrappedTask runTask(@NotNull Runnable runnable) {
        return this.setupTask(this.globalRegionScheduler.run(this.plugin, __ -> runnable.run()));
    }

    @Override
    @NotNull
    public WrappedTask runTaskAsynchronously(@NotNull Runnable runnable) {
        return this.setupTask(this.asyncScheduler.runNow(this.plugin, __ -> runnable.run()));
    }

    @Override
    @Nullable
    public WrappedTask runTaskAtEntity(@NotNull Entity entity, @NotNull Runnable runnable) {
        return this.setupTask(entity.getScheduler().run(this.plugin, __ -> runnable.run(), EMPTY_RUNNABLE));
    }

    @Override
    @NotNull
    public WrappedTask runTaskAtLocation(@NotNull Location location, @NotNull Runnable runnable) {
        return this.setupTask(this.regionScheduler.run(this.plugin, location, __ -> runnable.run()));
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimer(@NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(this.globalRegionScheduler.runAtFixedRate(this.plugin, __ -> runnable.run(), delay, period));
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimerAsynchronously(@NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(this.asyncScheduler.runAtFixedRate(this.plugin, __ -> runnable.run(), FoliaWrappedScheduler.toMillis(delay), FoliaWrappedScheduler.toMillis(period), TimeUnit.MILLISECONDS));
    }

    @Override
    @Nullable
    public WrappedTask runTaskTimerAtEntity(@NotNull Entity entity, @NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(entity.getScheduler().runAtFixedRate(this.plugin, __ -> runnable.run(), EMPTY_RUNNABLE, delay, period));
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimerAtLocation(@NotNull Location location, @NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(this.regionScheduler.runAtFixedRate(this.plugin, location, __ -> runnable.run(), delay, period));
    }

    @Override
    @NotNull
    public WrappedTask runTaskLater(@NotNull Runnable runnable, long delay) {
        return this.setupTask(this.globalRegionScheduler.runDelayed(this.plugin, __ -> runnable.run(), delay));
    }

    @Override
    @NotNull
    public WrappedTask runTaskLaterAsynchronously(@NotNull Runnable runnable, long delay) {
        return this.setupTask(this.asyncScheduler.runDelayed(this.plugin, __ -> runnable.run(), FoliaWrappedScheduler.toMillis(delay), TimeUnit.MILLISECONDS));
    }

    @Override
    @Nullable
    public WrappedTask runTaskLaterAtEntity(@NotNull Entity entity, @NotNull Runnable runnable, long delay) {
        return this.setupTask(entity.getScheduler().runDelayed(this.plugin, __ -> runnable.run(), EMPTY_RUNNABLE, delay));
    }

    @Override
    @NotNull
    public WrappedTask runTaskLaterAtLocation(@NotNull Location location, @NotNull Runnable runnable, long delay) {
        return this.setupTask(this.regionScheduler.runDelayed(this.plugin, location, __ -> runnable.run(), delay));
    }

    private @UnknownNullability WrappedTask setupTask(@Nullable ScheduledTask task) {
        if (task == null) {
            return null;
        }
        return new FoliaWrappedTask(task);
    }

    public static long toMillis(long ticks) {
        return ticks * 50L;
    }
}

