/*
 * Decompiled with CFR 0.152.
 */
package me.nahu.scheduler.wrapper.type;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public enum ImplementationType {
    FOLIA("io.papermc.paper.threadedregions.RegionizedServer", "io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler", "io.papermc.paper.threadedregions.scheduler.RegionScheduler"),
    BUKKIT("org.bukkit.scheduler.BukkitScheduler"),
    UNKNOWN(new String[0]);

    private final String[] classNames;

    private ImplementationType(String ... classNames) {
        this.classNames = classNames;
    }

    public String[] getClassNames() {
        return this.classNames;
    }

    public boolean isApplicable() {
        for (String className : this.getClassNames()) {
            try {
                Class.forName(className);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return false;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    @NotNull
    public static ImplementationType find() {
        return Arrays.stream(ImplementationType.values()).filter(ImplementationType::isApplicable).findFirst().orElse(UNKNOWN);
    }
}

