/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable;

import java.util.Objects;
import me.nahu.scheduler.wrapper.WrappedScheduler;
import me.nahu.scheduler.wrapper.WrappedSchedulerBuilder;
import net.hynse.stackable.command.ReloadCommand;
import net.hynse.stackable.command.TestRegexCommand;
import net.hynse.stackable.config.ConfigManager;
import net.hynse.stackable.listener.StackableListener;
import net.hynse.stackable.manager.StackSizeManager;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Stackable
extends JavaPlugin {
    public static Stackable instance;

    public void onEnable() {
        instance = this;
        WrappedSchedulerBuilder schedulerBuilder = WrappedSchedulerBuilder.builder().plugin((Plugin)this);
        WrappedScheduler scheduler = schedulerBuilder.build();
        this.saveDefaultConfig();
        ConfigManager configManager = new ConfigManager();
        StackSizeManager stackSizeManager = new StackSizeManager(configManager);
        configManager.loadConfig();
        instance.saveDefaultConfig();
        StackableListener eventListener = new StackableListener(stackSizeManager, scheduler);
        this.getServer().getPluginManager().registerEvents((Listener)eventListener, (Plugin)this);
        Objects.requireNonNull(this.getCommand("stackablereload")).setExecutor((CommandExecutor)new ReloadCommand(configManager));
        TestRegexCommand testRegexCommand = new TestRegexCommand();
        Objects.requireNonNull(this.getCommand("stackabletest")).setExecutor((CommandExecutor)testRegexCommand);
        Objects.requireNonNull(this.getCommand("stackabletest")).setTabCompleter((TabCompleter)testRegexCommand);
        this.getLogger().info("Stackable plugin enabled with " + configManager.getDirectMaterialCount() + " direct materials and " + configManager.getWildcardPatternCount() + " wildcard patterns for custom stack sizes.");
    }

    public void onDisable() {
        this.getLogger().info("Stackable plugin disabled.");
    }
}

