/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.hynse.stackable.util.RegexUtil;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TestRegexCommand
implements CommandExecutor,
TabCompleter {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("stackable.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command.");
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /stackabletest <pattern> [material]");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Examples:");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  /stackabletest .*_BOAT - Test a pattern against all materials");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  /stackabletest .*WOOL WHITE_WOOL - Test if pattern matches specific material");
            return true;
        }
        String pattern = args[0];
        if (args.length > 1) {
            try {
                String materialName = args[1].toUpperCase();
                Material material = Material.valueOf((String)materialName);
                boolean matches = RegexUtil.testPattern(pattern, material.name());
                if (matches) {
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Pattern '" + pattern + "' MATCHES material '" + material.name() + "'");
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Pattern '" + pattern + "' does NOT match material '" + material.name() + "'");
                }
            }
            catch (IllegalArgumentException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid material name: " + args[1]);
            }
            return true;
        }
        ArrayList<String> matches = new ArrayList<String>();
        int count = 0;
        for (Material material : Material.values()) {
            if (!RegexUtil.testPattern(pattern, material.name())) continue;
            matches.add(material.name());
            ++count;
            if (matches.size() >= 15) break;
        }
        if (count > 0) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Pattern '" + pattern + "' matches " + count + " materials.");
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "First " + Math.min(count, 15) + " matches: " + String.join((CharSequence)", ", matches));
            if (count > 15) {
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "...and " + (count - 15) + " more.");
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Pattern '" + pattern + "' does not match any materials.");
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            String partialMaterial = args[1].toUpperCase();
            return Arrays.stream(Material.values()).map(Enum::name).filter(name -> name.startsWith(partialMaterial)).limit(20L).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

