/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable.config;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.hynse.stackable.Stackable;
import net.hynse.stackable.util.RegexUtil;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final Map<Material, Integer> stackableItems = new ConcurrentHashMap<Material, Integer>();
    private final Map<String, Integer> wildcardPatterns = new ConcurrentHashMap<String, Integer>();

    public void loadConfig() {
        this.stackableItems.clear();
        this.wildcardPatterns.clear();
        RegexUtil.clearCache();
        FileConfiguration config = Stackable.instance.getConfig();
        if (config.contains("items") && config.isConfigurationSection("items")) {
            Set keys = Objects.requireNonNull(config.getConfigurationSection("items")).getKeys(false);
            for (String key : keys) {
                int maxStackSize = config.getInt("items." + key);
                if (this.isWildcardPattern(key)) {
                    this.wildcardPatterns.put(key, maxStackSize);
                    if (Stackable.instance.getConfig().getBoolean("debug", false)) {
                        Stackable.instance.getLogger().info("[DEBUG] Added wildcard pattern: '" + key + "' with max stack size: " + maxStackSize);
                        continue;
                    }
                    Stackable.instance.getLogger().fine("Added wildcard pattern: " + key + " with max stack size: " + maxStackSize);
                    continue;
                }
                try {
                    Material mat = Material.valueOf((String)key.toUpperCase());
                    this.stackableItems.put(mat, maxStackSize);
                    Stackable.instance.getLogger().fine("Added material: " + key + " with max stack size: " + maxStackSize);
                }
                catch (IllegalArgumentException e) {
                    Stackable.instance.getLogger().warning("Invalid material in config: " + key);
                }
            }
        }
        Stackable.instance.getLogger().info("Loaded " + this.stackableItems.size() + " direct materials and " + this.wildcardPatterns.size() + " wildcard patterns for custom stack sizes.");
    }

    public void reloadConfig() {
        Stackable.instance.reloadConfig();
        this.loadConfig();
        Stackable.instance.getLogger().info("Stackable configuration reloaded: " + this.stackableItems.size() + " items and " + this.wildcardPatterns.size() + " wildcard patterns loaded.");
    }

    private boolean isWildcardPattern(String str) {
        if (str.contains("*")) {
            return true;
        }
        try {
            Material.valueOf((String)str.toUpperCase());
            return false;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public boolean isStackableItem(Material material) {
        if (this.stackableItems.containsKey(material)) {
            return true;
        }
        return RegexUtil.getMatchOrDefault(material, this.wildcardPatterns, -1) != -1;
    }

    public int getMaxStackSize(Material material) {
        if (this.stackableItems.containsKey(material)) {
            return this.stackableItems.get(material);
        }
        return RegexUtil.getMatchOrDefault(material, this.wildcardPatterns, material.getMaxStackSize());
    }

    public int getDirectMaterialCount() {
        return this.stackableItems.size();
    }

    public int getWildcardPatternCount() {
        return this.wildcardPatterns.size();
    }
}

