/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable.listener;

import me.nahu.scheduler.wrapper.WrappedScheduler;
import net.hynse.stackable.manager.StackSizeManager;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class StackableListener
implements Listener {
    private final StackSizeManager stackSizeManager;
    private final WrappedScheduler scheduler;

    public StackableListener(StackSizeManager stackSizeManager, WrappedScheduler scheduler) {
        this.stackSizeManager = stackSizeManager;
        this.scheduler = scheduler;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryClick(InventoryClickEvent e) {
        this.scheduler.runTaskAtEntity((Entity)e.getWhoClicked(), () -> this.stackSizeManager.applyCustomStackSize(e.getCurrentItem()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onEntityPickup(EntityPickupItemEvent e) {
        this.scheduler.runTaskAtEntity((Entity)e.getEntity(), () -> this.stackSizeManager.applyCustomStackSize(e.getItem().getItemStack()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryMove(InventoryMoveItemEvent e) {
        Location location = e.getDestination().getLocation();
        if (location != null) {
            this.scheduler.runTaskAtLocation(location, () -> this.stackSizeManager.applyCustomStackSize(e.getItem()));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockDispense(BlockDispenseEvent e) {
        this.scheduler.runTaskAtLocation(e.getBlock().getLocation(), () -> this.stackSizeManager.applyCustomStackSize(e.getItem()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent e) {
        this.scheduler.runTaskAtEntity((Entity)e.getEntity(), () -> {
            ItemStack item = e.getEntity().getItemStack();
            this.stackSizeManager.applyCustomStackSize(item);
        });
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPrepareCrafter(CrafterCraftEvent e) {
        this.scheduler.runTaskAtLocation(e.getBlock().getLocation(), () -> this.stackSizeManager.applyCustomStackSize(e.getResult()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onFurnaceSmelt(FurnaceSmeltEvent e) {
        this.scheduler.runTaskAtLocation(e.getBlock().getLocation(), () -> this.stackSizeManager.applyCustomStackSize(e.getResult()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryPickupItem(InventoryPickupItemEvent e) {
        this.scheduler.runTaskAtLocation(e.getItem().getLocation(), () -> this.stackSizeManager.applyCustomStackSize(e.getItem().getItemStack()));
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onInventoryCreative(InventoryCreativeEvent e) {
        this.scheduler.runTaskAtEntity((Entity)e.getWhoClicked(), () -> this.stackSizeManager.applyCustomStackSize(e.getCurrentItem()));
    }

    public void fixInventory(Inventory inv) {
        if (inv == null) {
            return;
        }
        this.stackSizeManager.applyCustomStackSizeToAll(inv.getContents());
    }
}

