/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable.manager;

import net.hynse.stackable.config.ConfigManager;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class StackSizeManager {
    private final ConfigManager configManager;

    public StackSizeManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void applyCustomStackSize(ItemStack item) {
        if (item == null) {
            return;
        }
        Material material = item.getType();
        if (!this.configManager.isStackableItem(material)) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setMaxStackSize(Integer.valueOf(this.configManager.getMaxStackSize(material)));
            item.setItemMeta(meta);
        }
    }

    public void applyCustomStackSizeToAll(ItemStack[] items) {
        if (items == null) {
            return;
        }
        for (ItemStack item : items) {
            this.applyCustomStackSize(item);
        }
    }
}

