/*
 * Decompiled with CFR 0.152.
 */
package net.hynse.stackable.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.hynse.stackable.Stackable;
import org.bukkit.Material;

public class RegexUtil {
    private static final char WILDCARD = '*';
    private static final Map<Material, Integer> matchCache = new ConcurrentHashMap<Material, Integer>();

    public static int getMatchOrDefault(Material material, Map<String, Integer> patterns, int def) {
        if (matchCache.containsKey(material)) {
            return matchCache.get(material);
        }
        String materialName = material.name().toUpperCase();
        RegexUtil.logDebug("Checking patterns for material: " + materialName);
        for (Map.Entry<String, Integer> entry : patterns.entrySet()) {
            String pattern;
            boolean matches = RegexUtil.matchWildcard(pattern = entry.getKey().toUpperCase(), materialName);
            RegexUtil.logDebug("  Pattern '" + pattern + "' " + (matches ? "MATCHES" : "does not match") + " material '" + materialName + "'");
            if (!matches) continue;
            int value = entry.getValue();
            matchCache.put(material, value);
            RegexUtil.logDebug("  Found match! Setting stack size to " + value);
            return value;
        }
        RegexUtil.logDebug("  No pattern matched. Using default value: " + def);
        return def;
    }

    public static void clearCache() {
        matchCache.clear();
    }

    private static void logDebug(String msg) {
        if (Stackable.instance != null && Stackable.instance.getConfig().getBoolean("debug", false)) {
            Stackable.instance.getLogger().log(Level.INFO, "[DEBUG] " + msg);
        }
    }

    public static boolean testPattern(String pattern, String materialName) {
        boolean matches = RegexUtil.matchWildcard(pattern.toUpperCase(), materialName.toUpperCase());
        RegexUtil.logDebug("Testing pattern '" + pattern + "' against '" + materialName + "': " + (matches ? "MATCH" : "NO MATCH"));
        return matches;
    }

    public static boolean matchWildcard(String pattern, String text) {
        if (pattern.equals("*")) {
            return true;
        }
        if (!pattern.contains(String.valueOf('*'))) {
            return pattern.equals(text);
        }
        String[] parts = pattern.split("\\*", -1);
        int pos = 0;
        if (!parts[0].isEmpty()) {
            if (!text.startsWith(parts[0])) {
                return false;
            }
            pos = parts[0].length();
        }
        for (int i = 1; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            int idx = text.indexOf(part, pos);
            if (idx == -1) {
                return false;
            }
            pos = idx + part.length();
        }
        String last = parts[parts.length - 1];
        return last.isEmpty() || text.substring(pos).endsWith(last);
    }
}

