/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.crend.dynamiccrosshair.compat.AutoHudCompat;
import mod.crend.dynamiccrosshair.compat.YaclIntegration;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.ConfigHandler;
import mod.crend.dynamiccrosshair.impl.VanillaApiImpl;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.libbamboo.ConfigScreen;
import mod.crend.libbamboo.LibBamboo;
import mod.crend.libbamboo.PlatformUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="dynamiccrosshair")
public class DynamicCrosshairMod {
    public static ConfigHandler config;
    public static final Map<String, DynamicCrosshairApi> apis;
    public static final Set<String> alwaysCheckedApis;
    public static final DynamicCrosshairApi vanillaApi;

    public static void registerApi(DynamicCrosshairApi apiImpl) {
        if (PlatformUtils.isModLoaded((String)apiImpl.getModId())) {
            apiImpl.init();
            String identifier = apiImpl.getNamespace();
            apis.put(identifier, apiImpl);
            if (apiImpl.forceCheck()) {
                alwaysCheckedApis.add(identifier);
            }
        }
    }

    public static void init() {
        config = new ConfigHandler();
        if (LibBamboo.HAS_YACL) {
            YaclIntegration.listen();
        }
    }

    public DynamicCrosshairMod(FMLJavaModLoadingContext context) {
        ConfigScreen.register((ModLoadingContext)context, () -> ConfigHandler.CONFIG_STORE);
    }

    static {
        apis = new HashMap<String, DynamicCrosshairApi>();
        alwaysCheckedApis = new HashSet<String>();
        vanillaApi = new VanillaApiImpl();
    }

    @Mod.EventBusSubscriber(modid="dynamiccrosshair", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            DynamicCrosshairMod.init();
            CrosshairStyleManager.INSTANCE.init();
            TickEvent.ClientTickEvent.Post.BUS.addListener(ModBus::onClientTick);
        }

        @SubscribeEvent
        static void onInterModEnqueue(InterModEnqueueEvent event) {
            if (ModList.get().isLoaded("autohud")) {
                InterModComms.sendTo((String)"autohud", (String)"register_api", AutoHudCompat::new);
            }
        }

        @SubscribeEvent
        static void onInterModProcess(InterModProcessEvent event) {
            InterModComms.getMessages((String)"dynamiccrosshair", "register_api"::equals).map(msg -> (DynamicCrosshairApi)msg.messageSupplier().get()).forEach(DynamicCrosshairMod::registerApi);
        }

        static void onClientTick(TickEvent.ClientTickEvent.Post event) {
            CrosshairHandler.tick();
        }
    }
}

