/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mod.crend.dynamiccrosshair.compat.AutoHudCompat;
import mod.crend.dynamiccrosshair.compat.YaclIntegration;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.ConfigHandler;
import mod.crend.dynamiccrosshair.impl.VanillaApiImpl;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.libbamboo.ConfigScreen;
import mod.crend.libbamboo.LibBamboo;
import mod.crend.libbamboo.PlatformUtils;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="dynamiccrosshair")
public class DynamicCrosshairMod {
    public static ConfigHandler config;
    public static final Map<String, DynamicCrosshairApi> apis;
    public static final Set<String> alwaysCheckedApis;
    public static final DynamicCrosshairApi vanillaApi;

    public static void registerApi(DynamicCrosshairApi apiImpl) {
        if (PlatformUtils.isModLoaded((String)apiImpl.getModId())) {
            apiImpl.init();
            String identifier = apiImpl.getNamespace();
            apis.put(identifier, apiImpl);
            if (apiImpl.forceCheck()) {
                alwaysCheckedApis.add(identifier);
            }
        }
    }

    public static void init() {
        config = new ConfigHandler();
        if (LibBamboo.HAS_YACL) {
            YaclIntegration.listen();
        }
    }

    static {
        apis = new HashMap<String, DynamicCrosshairApi>();
        alwaysCheckedApis = new HashSet<String>();
        vanillaApi = new VanillaApiImpl();
    }

    @EventBusSubscriber(modid="dynamiccrosshair", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        static void onClientSetup(FMLClientSetupEvent event) {
            DynamicCrosshairMod.init();
            CrosshairStyleManager.INSTANCE.init();
            ConfigScreen.register(() -> ConfigHandler.CONFIG_STORE);
            NeoForge.EVENT_BUS.addListener(ModBus::onClientTick);
        }

        @SubscribeEvent
        static void onInterModEnqueue(InterModEnqueueEvent event) {
            if (ModList.get().isLoaded("autohud")) {
                InterModComms.sendTo((String)"autohud", (String)"register_api", AutoHudCompat::new);
            }
        }

        @SubscribeEvent
        static void onInterModProcess(InterModProcessEvent event) {
            InterModComms.getMessages((String)"dynamiccrosshair", "register_api"::equals).map(msg -> (DynamicCrosshairApi)msg.messageSupplier().get()).forEach(DynamicCrosshairMod::registerApi);
        }

        static void onClientTick(ClientTickEvent.Post event) {
            CrosshairHandler.tick();
        }
    }
}

