/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.entity;

import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ArmorStand.class})
public abstract class ArmorStandEntityMixin
extends LivingEntity
implements DynamicCrosshairEntity {
    @Shadow
    protected abstract EquipmentSlot getClickedSlot(Vec3 var1);

    @Shadow
    protected abstract boolean isDisabled(EquipmentSlot var1);

    @Shadow
    public abstract boolean showArms();

    protected ArmorStandEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        if (context.isMainHand() || context.getItemStack(InteractionHand.MAIN_HAND).is(Items.NAME_TAG)) {
            ItemStack itemStack = context.getItemStack();
            if (itemStack.isEmpty()) {
                Vec3 hitPos = context.getHitResult().getLocation().subtract(this.position());
                EquipmentSlot slot = this.getClickedSlot(hitPos);
                if (this.hasItemInSlot(slot)) {
                    return InteractionType.TAKE_ITEM_FROM_ENTITY;
                }
            } else if (itemStack.is(Items.NAME_TAG)) {
                if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                    return InteractionType.USE_ITEM_ON_ENTITY;
                }
            } else {
                EquipmentSlot slot = this.getEquipmentSlotForItem(itemStack);
                if (!(this.isDisabled(slot) || slot.getType() == EquipmentSlot.Type.HAND && !this.showArms() || this.hasItemInSlot(slot) && itemStack.getCount() != 1)) {
                    return InteractionType.PLACE_ITEM_ON_ENTITY;
                }
            }
        }
        return InteractionType.NO_ACTION;
    }
}

