/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.component;

import mod.crend.dynamiccrosshair.impl.CrosshairContextImpl;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"dynamiccrosshair");
    HitState previousState;
    HitStateFluid previousFluidState = null;
    Vec3 previousPosition;
    public final CrosshairContext context = new CrosshairContextImpl();

    public boolean changed(HitResult hitResult, LocalPlayer player) {
        HitState newState;
        switch (hitResult.getType()) {
            default: {
                throw new MatchException(null, null);
            }
            case BLOCK: {
                HitState hitState = new HitStateBlock(player, (BlockHitResult)hitResult);
                break;
            }
            case ENTITY: {
                HitState hitState = new HitStateEntity(player, (EntityHitResult)hitResult);
                break;
            }
            case MISS: {
                HitState hitState = newState = new HitStateMiss(player, hitResult);
            }
        }
        if (this.previousState == null) {
            this.previousState = newState;
            return true;
        }
        Vec3 newPosition = player.position();
        if (!newPosition.equals((Object)this.previousPosition)) {
            this.previousPosition = newPosition;
            this.previousState = newState;
            this.context.invalidateHitResult(hitResult);
            return true;
        }
        for (DynamicCrosshairApi api : this.context.apis()) {
            try {
                if (!api.forceInvalidate(this.context)) continue;
                this.previousState = newState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
            catch (RuntimeException e) {
                LOGGER.error("Exception occurred during evaluation of API {}", (Object)api.getModId(), (Object)e);
            }
        }
        if (newState.isChanged(this.previousState)) {
            this.previousState = newState;
            if (this.previousFluidState != null) {
                this.previousFluidState = null;
                this.context.invalidateHitResult(hitResult);
            }
            return true;
        }
        if (!player.getUseItem().isEmpty()) {
            return true;
        }
        BlockHitResult fluidHitResult = this.context.raycastWithFluid();
        if (fluidHitResult.getType() == HitResult.Type.BLOCK) {
            HitStateFluid newFluidState = new HitStateFluid(fluidHitResult);
            if (newFluidState.isChanged(this.previousFluidState)) {
                this.previousFluidState = newFluidState;
                this.context.invalidateHitResult(hitResult);
                return true;
            }
        } else if (this.previousFluidState != null) {
            this.previousFluidState = null;
            this.context.invalidateHitResult(hitResult);
            return true;
        }
        return false;
    }

    private static class HitStateFluid {
        final int level;
        final Fluid fluid;

        public HitStateFluid(BlockHitResult fluidHitResult) {
            assert (Minecraft.getInstance().level != null);
            FluidState fluidState = Minecraft.getInstance().level.getFluidState(fluidHitResult.getBlockPos());
            this.fluid = fluidState.getType();
            this.level = this.fluid.getAmount(fluidState);
        }

        public boolean isChanged(HitStateFluid other) {
            return other == null || this.fluid != other.fluid || this.level != other.level;
        }
    }

    private class HitStateBlock
    extends HitState {
        final int x;
        final int y;
        final int z;
        final Direction side;
        final BlockState blockState;

        public HitStateBlock(LocalPlayer player, BlockHitResult blockHitResult) {
            super(player, (HitResult)blockHitResult);
            BlockPos blockPos = blockHitResult.getBlockPos();
            this.x = blockPos.getX();
            this.y = blockPos.getY();
            this.z = blockPos.getZ();
            this.side = blockHitResult.getDirection();
            assert (Minecraft.getInstance().level != null);
            this.blockState = Minecraft.getInstance().level.getBlockState(blockPos);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateBlock) {
                HitStateBlock otherBlock = (HitStateBlock)other;
                if (this.x == otherBlock.x && this.y == otherBlock.y && this.z == otherBlock.z && this.side == otherBlock.side && this.blockState == otherBlock.blockState) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateEntity
    extends HitState {
        final Entity entity;

        public HitStateEntity(LocalPlayer player, EntityHitResult entityHitResult) {
            super(player, (HitResult)entityHitResult);
            this.entity = entityHitResult.getEntity();
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateEntity) {
                HitStateEntity otherEntity = (HitStateEntity)other;
                if (this.entity == otherEntity.entity) {
                    return false;
                }
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitStateMiss
    extends HitState {
        public HitStateMiss(LocalPlayer player, HitResult hitResult) {
            super(player, hitResult);
        }

        @Override
        public boolean isChanged(HitState other) {
            if (!super.isChanged(other) && other instanceof HitStateMiss) {
                return false;
            }
            State.this.context.invalidateHitResult(this.hitResult);
            return true;
        }
    }

    private class HitState {
        final HitResult hitResult;
        final ItemStack mainHandStack;
        final ItemStack offHandStack;
        final ItemStack activeStack;
        final InteractionHand activeHand;
        final boolean cancelInteraction;
        final boolean isCoolingDown;
        final boolean isOnGround;
        final boolean isGliding;

        public HitState(LocalPlayer player, HitResult hitResult) {
            this.hitResult = hitResult;
            this.mainHandStack = player.getMainHandItem().copy();
            this.offHandStack = player.getOffhandItem().copy();
            this.activeStack = player.getUseItem().copy();
            this.activeHand = player.getUsedItemHand();
            this.cancelInteraction = player.isSecondaryUseActive();
            this.isCoolingDown = player.getCooldowns().isOnCooldown(this.mainHandStack.getItem()) || player.getCooldowns().isOnCooldown(this.offHandStack.getItem());
            this.isOnGround = player.onGround();
            this.isGliding = player.isFallFlying();
        }

        public boolean isChanged(HitState other) {
            boolean invalidated = false;
            if (!ItemStack.matches((ItemStack)this.mainHandStack, (ItemStack)other.mainHandStack)) {
                State.this.context.invalidateItem(InteractionHand.MAIN_HAND);
                invalidated = true;
            }
            if (!ItemStack.matches((ItemStack)this.offHandStack, (ItemStack)other.offHandStack)) {
                State.this.context.invalidateItem(InteractionHand.OFF_HAND);
                invalidated = true;
            }
            if (!ItemStack.matches((ItemStack)this.activeStack, (ItemStack)other.activeStack)) {
                State.this.context.invalidateItem(this.activeHand);
                invalidated = true;
            }
            return invalidated || this.cancelInteraction != other.cancelInteraction || this.isCoolingDown != other.isCoolingDown || this.isOnGround != other.isOnGround || this.isGliding != other.isGliding;
        }
    }
}

