/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.impl;

import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.crosshair.Crosshair;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairBlockTags;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairEntityTags;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairItemTags;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairRangedItem;
import mod.crend.libbamboo.tag.ClientTags;
import mod.crend.libbamboo.type.BlockOrTag;
import mod.crend.libbamboo.type.ItemOrTag;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;

public class VanillaApiImpl
implements DynamicCrosshairApi {
    private boolean fishHookStatus;

    public String getNamespace() {
        return "minecraft";
    }

    public boolean forceCheck() {
        return true;
    }

    public boolean forceInvalidate(CrosshairContext context) {
        if (context.isWithEntity() && context.getEntity().getType() == EntityType.ARMOR_STAND) {
            return true;
        }
        if (context.isWithBlock() && context.getBlock() instanceof ChiseledBookShelfBlock) {
            return true;
        }
        if (context.getItem() instanceof FishingRodItem) {
            boolean newFishHookStatus;
            boolean bl = newFishHookStatus = context.getPlayer().fishing != null;
            if (newFishHookStatus != this.fishHookStatus) {
                this.fishHookStatus = newFishHookStatus;
                return true;
            }
        }
        return false;
    }

    public Crosshair overrideFromItem(CrosshairContext context, InteractionType interactionType) {
        boolean isRangedMeleeWeapon = false;
        if (context.api().isMeleeWeapon(context.getItemStack()) && context.includeMeleeWeapon() && interactionType != InteractionType.USABLE_TOOL) {
            BlockState blockState;
            if (context.canUseWeaponAsTool() && (blockState = context.getBlockState()).getDestroySpeed((BlockGetter)context.getWorld(), context.getBlockPos()) == 0.0f) {
                if (DynamicCrosshairMod.config.dynamicCrosshairMeleeWeaponOnBreakableBlock()) {
                    return new Crosshair(InteractionType.MELEE_WEAPON);
                }
                return new Crosshair(InteractionType.CORRECT_TOOL);
            }
            if (context.isWithEntity() && !DynamicCrosshairMod.config.dynamicCrosshairMeleeWeaponOnEntity()) {
                return new Crosshair(InteractionType.NO_ACTION);
            }
            if (context.api().isRangedWeapon(context.getItemStack())) {
                isRangedMeleeWeapon = true;
                interactionType = InteractionType.RANGED_WEAPON;
            }
        }
        switch (interactionType) {
            case TOOL: 
            case USABLE_TOOL: {
                Crosshair crosshair = new Crosshair(interactionType);
                if (!context.isWithBlock()) break;
                return Crosshair.combine((Crosshair)crosshair, (Crosshair)new Crosshair(context.checkToolWithBlock()));
            }
            case RANGED_WEAPON: {
                if (DynamicCrosshairMod.config.dynamicCrosshairHoldingRangedWeapon() == UsableCrosshairPolicy.Disabled) break;
                if (DynamicCrosshairMod.config.dynamicCrosshairHoldingRangedWeapon() == UsableCrosshairPolicy.Always) {
                    return new Crosshair(InteractionType.RANGED_WEAPON);
                }
                DynamicCrosshairRangedItem rangedItem = (DynamicCrosshairRangedItem)context.getItem();
                if (rangedItem.dynamiccrosshair$isCharged(context)) {
                    if (isRangedMeleeWeapon) {
                        return new Crosshair(InteractionType.MELEE_WEAPON, InteractionType.RANGED_WEAPON_CHARGED);
                    }
                    return new Crosshair(InteractionType.RANGED_WEAPON_CHARGED);
                }
                if (rangedItem.dynamiccrosshair$isCharging(context)) {
                    if (isRangedMeleeWeapon) {
                        return new Crosshair(InteractionType.MELEE_WEAPON, InteractionType.RANGED_WEAPON_CHARGING);
                    }
                    return new Crosshair(InteractionType.RANGED_WEAPON_CHARGING);
                }
                if (isRangedMeleeWeapon) {
                    return new Crosshair(InteractionType.MELEE_WEAPON);
                }
                return new Crosshair(InteractionType.FORCE_REGULAR_CROSSHAIR);
            }
            case EMPTY: {
                UsableCrosshairPolicy usableItemPolicy = DynamicCrosshairMod.config.dynamicCrosshairHoldingUsableItem();
                if (usableItemPolicy == UsableCrosshairPolicy.Disabled) break;
                ItemStack itemStack = context.getItemStack();
                if ((usableItemPolicy == UsableCrosshairPolicy.Always || !context.isCoolingDown()) && context.api().isAlwaysUsable(itemStack)) {
                    return new Crosshair(InteractionType.USE_ITEM);
                }
                if (usableItemPolicy != UsableCrosshairPolicy.Always || !context.api().isUsable(itemStack)) break;
                return new Crosshair(InteractionType.USE_ITEM);
            }
        }
        return null;
    }

    public boolean isAlwaysInteractable(BlockState blockState) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairBlockTags.ALWAYS_INTERACTABLE, (Holder)blockState.getBlockHolder()) || BlockOrTag.isContainedIn((Block)blockState.getBlock(), DynamicCrosshairMod.config.getAdditionalInteractableBlocks());
    }

    public boolean isAlwaysInteractableInCreativeMode(BlockState blockState) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairBlockTags.ALWAYS_INTERACTABLE_IN_CREATIVE_MODE, (Holder)blockState.getBlockHolder());
    }

    public boolean isInteractable(BlockState blockState) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairBlockTags.INTERACTABLE, (Holder)blockState.getBlockHolder());
    }

    public boolean isAlwaysInteractable(EntityType<?> entityType) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairEntityTags.ALWAYS_INTERACTABLE, entityType);
    }

    public boolean isInteractable(EntityType<?> entityType) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairEntityTags.INTERACTABLE, entityType);
    }

    public boolean isAlwaysUsable(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.ALWAYS_USABLE, (Holder)itemStack.getItemHolder()) || itemStack.getItem().getUseAnimation(itemStack) == UseAnim.DRINK || ItemOrTag.isContainedIn((Item)itemStack.getItem(), DynamicCrosshairMod.config.getAdditionalUsableItems());
    }

    public boolean isAlwaysUsableOnBlock(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.ALWAYS_USABLE_ON_BLOCK, (Holder)itemStack.getItemHolder());
    }

    public boolean isAlwaysUsableOnEntity(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.ALWAYS_USABLE_ON_ENTITY, (Holder)itemStack.getItemHolder());
    }

    public boolean isAlwaysUsableOnMiss(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.ALWAYS_USABLE_ON_MISS, (Holder)itemStack.getItemHolder());
    }

    public boolean isUsable(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.USABLE, (Holder)itemStack.getItemHolder()) || itemStack.has(DataComponents.FOOD) || itemStack.has(DataComponents.JUKEBOX_PLAYABLE);
    }

    public boolean isBlock(ItemStack itemStack) {
        return itemStack.getItem() instanceof BlockItem || ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.BLOCKS, (Holder)itemStack.getItemHolder());
    }

    public boolean isMeleeWeapon(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.MELEE_WEAPONS, (Holder)itemStack.getItemHolder()) || ItemOrTag.isContainedIn((Item)itemStack.getItem(), DynamicCrosshairMod.config.getAdditionalMeleeWeapons());
    }

    public boolean isRangedWeapon(ItemStack itemStack) {
        if (ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.RANGED_WEAPONS, (Holder)itemStack.getItemHolder())) {
            return true;
        }
        if (ItemOrTag.isContainedIn((Item)itemStack.getItem(), DynamicCrosshairMod.config.getAdditionalRangedWeapons())) {
            return true;
        }
        return switch (itemStack.getItem().getUseAnimation(itemStack)) {
            case UseAnim.BOW, UseAnim.CROSSBOW, UseAnim.SPEAR -> true;
            default -> false;
        };
    }

    public boolean isShield(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.SHIELDS, (Holder)itemStack.getItemHolder()) || itemStack.getItem().getUseAnimation(itemStack) == UseAnim.BLOCK;
    }

    public boolean isThrowable(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.THROWABLES, (Holder)itemStack.getItemHolder()) || ItemOrTag.isContainedIn((Item)itemStack.getItem(), DynamicCrosshairMod.config.getAdditionalThrowables());
    }

    public boolean isTool(ItemStack itemStack) {
        return ClientTags.isInWithLocalFallback((TagKey)DynamicCrosshairItemTags.TOOLS, (Holder)itemStack.getItemHolder()) || ItemOrTag.isContainedIn((Item)itemStack.getItem(), DynamicCrosshairMod.config.getAdditionalTools());
    }
}

