/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshairapi.crosshair;

import java.util.List;
import java.util.function.Function;
import mod.crend.dynamiccrosshairapi.DynamicCrosshairApi;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.internal.ContextedApi;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public interface CrosshairContext {
    public ClientLevel getWorld();

    public LocalPlayer getPlayer();

    public HitResult getHitResult();

    public void invalidateHitResult(HitResult var1);

    public void invalidateItem(InteractionHand var1);

    public boolean isTargeting();

    public boolean isEmptyHanded();

    public boolean shouldInteract();

    public boolean isFlying();

    public boolean isWithBlock();

    public BlockPos getBlockPos();

    public BlockState getBlockState();

    default public Block getBlock() {
        return this.getBlockState().getBlock();
    }

    public BlockEntity getBlockEntity();

    public FluidState getFluidState();

    public BlockHitResult getBlockHitResult();

    public Direction getBlockHitSide();

    default public UseOnContext getItemUsageContext() {
        return new UseOnContext((Player)this.getPlayer(), this.getHand(), this.getBlockHitResult());
    }

    public BlockHitResult raycastWithFluid(ClipContext.Fluid var1);

    default public BlockHitResult raycastWithFluid() {
        return this.raycastWithFluid(ClipContext.Fluid.ANY);
    }

    public EntityHitResult raycastForEntity(double var1);

    public boolean isWithEntity();

    public Entity getEntity();

    public InteractionHand getHand();

    public void setHand(InteractionHand var1);

    public boolean isMainHand();

    public boolean isOffHand();

    public ItemStack getItemStack(InteractionHand var1);

    default public ItemStack getItemStack() {
        return this.getItemStack(this.getHand());
    }

    default public Item getItem() {
        return this.getItemStack().getItem();
    }

    public boolean isActiveItem();

    public boolean isCoolingDown();

    public boolean canPlaceItemAsBlock();

    public boolean canUseWeaponAsTool();

    public boolean includeUsableItem();

    public boolean includeThrowable();

    public boolean includeRangedWeapon();

    public boolean includeMeleeWeapon();

    public boolean includeTool();

    public boolean includeShield();

    public boolean includeHoldingBlock();

    public List<DynamicCrosshairApi> apis();

    public ContextedApi api();

    @Nullable
    public <R> R withApisUntilNonNull(Function<DynamicCrosshairApi, R> var1);

    public InteractionType checkToolWithBlock();
}

