/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config.gui;

import com.mojang.blaze3d.platform.NativeImage;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import mod.crend.dynamiccrosshair.config.gui.SelectCrosshairElement;
import mod.crend.dynamiccrosshair.style.AbstractCrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshair.style.CustomCrosshairStyle;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectCrosshairController
implements Controller<ResourceLocation> {
    Option<ResourceLocation> option;
    CustomCrosshairStyle editStyle = null;
    BufferedImage editImage;

    public SelectCrosshairController(Option<ResourceLocation> option) {
        this.option = option;
    }

    public Option<ResourceLocation> option() {
        return this.option;
    }

    public Component formatValue() {
        return Component.empty();
    }

    public List<AbstractCrosshairStyle> getButtons() {
        ArrayList<AbstractCrosshairStyle> buttons = new ArrayList<AbstractCrosshairStyle>();
        buttons.addAll(CrosshairStyleManager.INSTANCE.getBuiltinStyles());
        buttons.addAll(CrosshairStyleManager.INSTANCE.getCustomStyles());
        return buttons;
    }

    public boolean isInEditMode() {
        return this.editStyle != null;
    }

    public boolean isCustomStyle() {
        return CrosshairStyleManager.INSTANCE.isCustomStyle((ResourceLocation)this.option.pendingValue());
    }

    public void add() {
        this.editStyle = CrosshairStyleManager.INSTANCE.create();
        this.init(true);
        this.option.requestSet((Object)this.editStyle.identifier);
    }

    public void edit() {
        if (!this.isInEditMode() && this.isCustomStyle()) {
            this.editStyle = CrosshairStyleManager.INSTANCE.getCustomStyle((ResourceLocation)this.option.pendingValue());
            this.init(false);
        }
    }

    public void delete() {
        if (!this.isInEditMode() && this.isCustomStyle()) {
            CrosshairStyleManager.INSTANCE.delete((ResourceLocation)this.option.pendingValue());
            this.option.requestSet((Object)DynamicCrosshairStyles.DEFAULT);
        }
    }

    public void save() {
        if (this.isInEditMode() && this.isCustomStyle()) {
            CrosshairStyleManager.INSTANCE.save(this.editStyle, this.editImage);
        }
        this.editStyle = null;
    }

    public void cancel() {
        if (this.isInEditMode() && !CrosshairStyleManager.INSTANCE.reload(this.editStyle)) {
            CrosshairStyleManager.INSTANCE.remove((ResourceLocation)this.option.pendingValue());
            this.option.requestSet((Object)DynamicCrosshairStyles.DEFAULT);
        }
        this.editStyle = null;
    }

    public void registerTexture() {
        if (this.isInEditMode()) {
            CrosshairStyleManager.INSTANCE.registerTexture(this.editImage, this.editStyle.identifier);
        }
    }

    public void init(boolean newImage) {
        this.editImage = new BufferedImage(15, 15, 2);
        if (newImage) {
            this.registerTexture();
        } else {
            this.loadCurrentTexture();
        }
    }

    private void loadCurrentTexture() {
        NativeImage nativeImage;
        if (this.editStyle != null && (nativeImage = CrosshairStyleManager.INSTANCE.getTexture(this.editStyle.identifier)) != null) {
            int[] rgba = nativeImage.getPixels();
            int i = 0;
            int j = 0;
            for (int px : rgba) {
                this.editImage.setRGB(i, j, px);
                if (++i != 15) continue;
                i = 0;
                ++j;
            }
        }
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new SelectCrosshairElement(this, widgetDimension);
    }
}

