/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.block;

import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RedStoneWireBlock.class})
public abstract class RedstoneWireBlockMixin
extends Block
implements DynamicCrosshairBlock {
    @Shadow
    @Final
    private BlockState crossState;
    @Shadow
    @Final
    public static IntegerProperty POWER;

    public RedstoneWireBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Shadow
    private static boolean isDot(BlockState state) {
        return false;
    }

    @Shadow
    private static boolean isCross(BlockState state) {
        return false;
    }

    @Shadow
    protected abstract BlockState getConnectionState(BlockGetter var1, BlockState var2, BlockPos var3);

    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        BlockState state = context.getBlockState();
        if (RedstoneWireBlockMixin.isDot(state)) {
            return InteractionType.INTERACT_WITH_BLOCK;
        }
        if (RedstoneWireBlockMixin.isCross(state)) {
            BlockState blockState = RedstoneWireBlockMixin.isCross(state) ? this.defaultBlockState() : this.crossState;
            blockState = (BlockState)blockState.setValue((Property)POWER, (Comparable)((Integer)state.getValue((Property)POWER)));
            blockState = this.getConnectionState((BlockGetter)context.getWorld(), blockState, context.getBlockPos());
            if (blockState != state) {
                return InteractionType.INTERACT_WITH_BLOCK;
            }
        }
        return InteractionType.NO_ACTION;
    }
}

