/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.entity;

import mod.crend.dynamiccrosshair.mixin.entity.TameableEntityMixin;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Wolf.class})
public abstract class WolfEntityMixin
extends TameableEntityMixin
implements DynamicCrosshairEntity,
NeutralMob {
    @Shadow
    public abstract DyeColor getCollarColor();

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        if (this.isTame() && this.isOwnedBy((LivingEntity)context.getPlayer())) {
            if (this.isFood(context.getItemStack()) && this.getHealth() < this.getMaxHealth()) {
                return InteractionType.USE_ITEM_ON_ENTITY;
            }
            Item item = context.getItem();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (this.getCollarColor() != dye.getDyeColor()) {
                    return InteractionType.USE_ITEM_ON_ENTITY;
                }
            }
            if (this.isEquippableInSlot(context.getItemStack(), EquipmentSlot.BODY) && !this.isWearingBodyArmor() && !this.isBaby()) {
                return InteractionType.PLACE_ITEM_ON_ENTITY;
            }
            if (context.getItemStack().is(Items.SHEARS) && this.isWearingBodyArmor() && (!EnchantmentHelper.has((ItemStack)this.getBodyArmorItem(), (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) || context.getPlayer().isCreative())) {
                return InteractionType.TAKE_ITEM_FROM_ENTITY;
            }
            return InteractionType.INTERACT_WITH_ENTITY;
        }
        if (context.getItemStack().is(Items.BONE) && !this.isAngry()) {
            return InteractionType.USE_ITEM_ON_ENTITY;
        }
        return super.dynamiccrosshair$compute(context);
    }
}

