/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin;

import java.util.Objects;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairItem;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairRangedItem;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Item.class})
public abstract class DynamicCrosshairBaseItem
implements DynamicCrosshairItem,
DynamicCrosshairRangedItem {
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        ItemStack itemStack = context.getItemStack();
        if (itemStack.has(DataComponents.FOOD) && (context.getPlayer().canEat(false) || Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).canAlwaysEat())) {
            return InteractionType.CONSUME_ITEM;
        }
        InteractionType interactionType = (InteractionType)context.withApisUntilNonNull(api -> {
            if (api.isAlwaysUsable(itemStack)) {
                return InteractionType.USE_ITEM;
            }
            if (api.isAlwaysUsableOnBlock(itemStack) && context.isWithBlock()) {
                return InteractionType.USE_ITEM_ON_BLOCK;
            }
            if (api.isAlwaysUsableOnEntity(itemStack) && context.isWithEntity()) {
                return InteractionType.USE_ITEM_ON_ENTITY;
            }
            if (api.isAlwaysUsableOnMiss(itemStack) && !context.isTargeting()) {
                return InteractionType.USE_ITEM;
            }
            if (api.isTool(itemStack)) {
                return InteractionType.TOOL;
            }
            if (api.isThrowable(itemStack)) {
                return InteractionType.THROW_ITEM;
            }
            if (api.isShield(itemStack)) {
                return InteractionType.SHIELD;
            }
            if (api.isMeleeWeapon(itemStack)) {
                return InteractionType.MELEE_WEAPON;
            }
            if (api.isRangedWeapon(itemStack)) {
                return InteractionType.RANGED_WEAPON;
            }
            if (api.isBlock(itemStack)) {
                return InteractionType.PLACE_BLOCK;
            }
            return null;
        });
        if (interactionType != null) {
            return interactionType;
        }
        if (itemStack.has(DataComponents.EQUIPPABLE) && context.getPlayer().isEquippableInSlot(itemStack, ((Equippable)itemStack.get(DataComponents.EQUIPPABLE)).slot())) {
            return InteractionType.EQUIP_ITEM;
        }
        return InteractionType.EMPTY;
    }

    public boolean dynamiccrosshair$isCharging(CrosshairContext context) {
        return context.isActiveItem() && context.getPlayer().getUseItemRemainingTicks() > 0;
    }

    public boolean dynamiccrosshair$isCharged(CrosshairContext context) {
        return true;
    }
}

