/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Function;
import mod.crend.dynamiccrosshair.DynamicCrosshairMod;
import mod.crend.dynamiccrosshair.compat.AutoHudCompat;
import mod.crend.dynamiccrosshair.component.CrosshairComponent;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.style.CrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import mod.crend.dynamiccrosshair.style.CrosshairStyledPart;
import mod.crend.dynamiccrosshairapi.VersionUtils;
import mod.crend.libbamboo.render.CustomFramebufferRenderer;
import net.minecraft.class_1041;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(int argb, boolean enableBlend) {
        RenderSystem.setShaderColor((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)((float)(argb >> 24 & 0xFF) / 255.0f));
        if (!enableBlend || autoHudCompat) {
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
    }

    public static void preRender() {
        CrosshairStyle defaultStyle = CrosshairHandler.getDefaultCrosshair();
        CrosshairRenderer.setColor(defaultStyle.color(), defaultStyle.enableBlend());
    }

    public static void fixCenteredCrosshairPre(class_332 context, int x, int y) {
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        double i = (double)window.method_4489() / scale;
        double j = (double)window.method_4506() / scale;
        double dx = (i - 15.0) / 2.0 - (double)x;
        double dy = (j - 15.0) / 2.0 - (double)y;
        context.method_51448().method_22903();
        context.method_51448().method_22904(dx, dy, 0.0);
    }

    public static void fixCenteredCrosshairPost(class_332 context) {
        context.method_51448().method_22909();
    }

    public static void renderCrosshair(class_332 context, class_2960 style, Function<class_2960, class_1921> renderLayer, int x, int y) {
        CrosshairStyleManager.INSTANCE.get(style).draw(context, renderLayer, x, y);
    }

    public static void renderCrosshair(class_332 context, CrosshairStyle style, int x, int y) {
        CrosshairRenderer.setColor(style.color(), style.enableBlend());
        CrosshairRenderer.renderCrosshair(context, style.identifier(), style.enableBlend() ? VersionUtils.getCrosshair() : VersionUtils.getGuiTextured(), x, y);
    }

    private static void preRenderHalf() {
        RenderSystem.defaultBlendFunc();
        CustomFramebufferRenderer.init();
    }

    private static void postRenderHalf(class_332 context, boolean blend) {
        RenderSystem.enableBlend();
        if (blend) {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        } else {
            RenderSystem.defaultBlendFunc();
        }
        CustomFramebufferRenderer.draw((class_332)context);
        context.method_51452();
    }

    private static void renderStyles(class_332 context, int x, int y, List<CrosshairStyledPart> styles) {
        for (CrosshairStyledPart part : styles) {
            if (autoHudCompat) {
                AutoHudCompat.renderCrosshair(context, part.part(), part.style(), x, y);
                continue;
            }
            CrosshairRenderer.renderCrosshair(context, part.style(), x, y);
        }
    }

    public static void render(class_332 context, int x, int y) {
        context.method_51452();
        CrosshairComponent crosshair = CrosshairHandler.getActiveCrosshair();
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithBlend());
        CrosshairRenderer.postRenderHalf(context, true);
        CrosshairRenderer.preRenderHalf();
        CrosshairRenderer.renderStyles(context, x, y, crosshair.getStylesWithoutBlend());
        CrosshairRenderer.postRenderHalf(context, false);
    }

    public static void postRender() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
    }

    public static void wrapRender(class_332 context, int x, int y, Runnable originalRenderCall, Runnable noBlendRenderCall) {
        if (!CrosshairHandler.forceShowCrosshair && !CrosshairHandler.shouldShowCrosshair()) {
            return;
        }
        CrosshairRenderer.preRender();
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPre(context, x, y);
        }
        if (DynamicCrosshairMod.config.isDynamicCrosshairStyle()) {
            CrosshairRenderer.render(context, x, y);
        } else if (!CrosshairHandler.getDefaultCrosshair().enableBlend()) {
            noBlendRenderCall.run();
            context.method_51452();
        } else {
            originalRenderCall.run();
        }
        if (DynamicCrosshairMod.config.isFixCenteredCrosshair()) {
            CrosshairRenderer.fixCenteredCrosshairPost(context);
        }
        CrosshairRenderer.postRender();
    }
}

