/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mod.crend.dynamiccrosshair.config.BlockCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.CrosshairPolicy;
import mod.crend.dynamiccrosshair.config.UsableCrosshairPolicy;
import mod.crend.dynamiccrosshair.config.gui.CrosshairStyleController;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import mod.crend.libbamboo.auto.annotation.AutoYaclConfig;
import mod.crend.libbamboo.auto.annotation.Category;
import mod.crend.libbamboo.auto.annotation.CustomController;
import mod.crend.libbamboo.auto.annotation.DescriptionImage;
import mod.crend.libbamboo.auto.annotation.EnableIf;
import mod.crend.libbamboo.auto.annotation.TransitiveObject;
import mod.crend.libbamboo.auto.annotation.Translation;
import mod.crend.libbamboo.opt.yacl.SerialEntry;
import mod.crend.libbamboo.render.ItemOrTagRenderer;
import mod.crend.libbamboo.type.BlockOrTag;
import mod.crend.libbamboo.type.ItemOrTag;
import net.minecraft.resources.ResourceLocation;

@AutoYaclConfig(modid="dynamiccrosshair", translationKey="dynamiccrosshair.title", filename="dynamiccrosshair.json5")
public class Config {
    @SerialEntry
    public boolean dynamicCrosshair = true;
    @SerialEntry
    public boolean disableDebugCrosshair = false;
    @SerialEntry
    public boolean thirdPersonCrosshair = false;
    @SerialEntry
    public boolean hideWithScreen = true;
    @SerialEntry
    public boolean hideWithMap = true;
    @SerialEntry
    public boolean fixCenteredCrosshair = false;
    @SerialEntry
    public CrosshairConfig crosshairConfig = new CrosshairConfig();
    @TransitiveObject
    @Category(name="style")
    @SerialEntry
    public CrosshairColorSettings color = new CrosshairColorSettings();
    @SerialEntry
    public boolean dynamicCrosshairStyle = true;
    @TransitiveObject
    @Category(name="style")
    @SerialEntry
    public CrosshairStyles crosshairStyle = new CrosshairStyles();
    @Category(name="style")
    @TransitiveObject
    @SerialEntry
    public CrosshairModifiers crosshairModifiers = new CrosshairModifiers();
    @Category(name="tweaks")
    @SerialEntry
    public boolean enableTweaks = true;
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfItemOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<ItemOrTag> additionalTools = Collections.emptyList();
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfItemOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<ItemOrTag> additionalMeleeWeapons = Collections.emptyList();
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfItemOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<ItemOrTag> additionalRangedWeapons = Collections.emptyList();
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfItemOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<ItemOrTag> additionalThrowables = Collections.emptyList();
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfItemOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<ItemOrTag> additionalUsableItems = Collections.emptyList();
    @Category(name="tweaks")
    @DescriptionImage(value=ItemOrTagRenderer.OfBlockOrTag.class)
    @EnableIf(field="enableTweaks", value=EnableIf.BooleanPredicate.class)
    @SerialEntry
    public List<BlockOrTag> additionalInteractableBlocks = Collections.emptyList();

    public static class CrosshairConfig {
        @SerialEntry
        public boolean onBlock = true;
        @SerialEntry
        public boolean onInteractableBlock = true;
        @SerialEntry
        public boolean onEntity = true;
        @SerialEntry
        public CrosshairPolicy holdingTool = CrosshairPolicy.Always;
        @SerialEntry
        public boolean displayCorrectTool = true;
        @SerialEntry
        public boolean holdingMeleeWeapon = true;
        @SerialEntry
        public boolean meleeWeaponOnEntity = false;
        @SerialEntry
        public boolean meleeWeaponOnBreakableBlock = false;
        @SerialEntry
        public UsableCrosshairPolicy holdingRangedWeapon = UsableCrosshairPolicy.Always;
        @SerialEntry
        public UsableCrosshairPolicy holdingThrowable = UsableCrosshairPolicy.IfInteractable;
        @SerialEntry
        public boolean holdingShield = true;
        @SerialEntry
        public BlockCrosshairPolicy holdingBlock = BlockCrosshairPolicy.IfInteractable;
        @EnableIf(field="holdingBlock", value=BlockCrosshairActivePredicate.class)
        @SerialEntry
        public boolean holdingBlockInOffhand = true;
        @SerialEntry
        public UsableCrosshairPolicy holdingUsableItem = UsableCrosshairPolicy.IfInteractable;
        @SerialEntry
        public boolean forceHoldingSpyglass = false;
    }

    public static class CrosshairColorSettings {
        @Translation(key="dynamiccrosshair.option.crosshairStyle.color.crosshairColor")
        @SerialEntry
        public boolean overrideColor = false;
        @Translation(key="dynamiccrosshair.option.crosshairStyle.color.customColor")
        @EnableIf(field="overrideColor", value=EnableIf.BooleanPredicate.class)
        @SerialEntry
        public Color customColor = new Color(-5588020, true);
        @Translation(key="dynamiccrosshair.option.crosshairStyle.color.enableBlend")
        @SerialEntry
        public boolean enableBlend = true;
    }

    public static class CrosshairStyles {
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings regular = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings onBlock = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings onEntity = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings holdingTool = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings holdingMeleeWeapon = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings holdingRangedWeapon = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings holdingThrowable = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings holdingBlock = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings interact = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings useItem = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings shield = new CrosshairStyleSettings();

        public CrosshairStyles() {
            this.regular.style = DynamicCrosshairStyles.CROSS_OPEN;
            this.onBlock.style = DynamicCrosshairStyles.CROSS_OPEN;
            this.onEntity.style = DynamicCrosshairStyles.CROSS_OPEN_DIAGONAL;
            this.holdingTool.style = DynamicCrosshairStyles.SQUARE;
            this.holdingMeleeWeapon.style = DynamicCrosshairStyles.CROSS_OPEN;
            this.holdingRangedWeapon.style = DynamicCrosshairStyles.CROSS_OPEN_DIAGONAL;
            this.holdingThrowable.style = DynamicCrosshairStyles.CIRCLE_LARGE;
            this.holdingBlock.style = DynamicCrosshairStyles.DIAMOND;
            this.interact.style = DynamicCrosshairStyles.BRACKETS;
            this.useItem.style = DynamicCrosshairStyles.BRACKETS_ROUND;
            this.shield.style = DynamicCrosshairStyles.BRACKETS_BOTTOM;
            this.holdingRangedWeapon.coalesce = false;
            this.holdingBlock.coalesce = false;
        }
    }

    public static class CrosshairModifiers {
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings modCorrectTool = new CrosshairStyleSettings();
        @CustomController(value=CrosshairStyleController.Factory.class)
        @SerialEntry
        public CrosshairStyleSettings modIncorrectTool = new CrosshairStyleSettings();

        public CrosshairModifiers() {
            this.modCorrectTool.style = DynamicCrosshairStyles.DOT;
            this.modCorrectTool.overrideColor = true;
            this.modCorrectTool.customColor = Color.GREEN;
            this.modCorrectTool.enableBlend = false;
            this.modIncorrectTool.style = DynamicCrosshairStyles.CROSS_DIAGONAL_SMALL;
            this.modIncorrectTool.overrideColor = true;
            this.modIncorrectTool.customColor = Color.RED;
            this.modIncorrectTool.enableBlend = false;
        }
    }

    public static class CrosshairStyleSettings {
        @SerialEntry
        public ResourceLocation style = DynamicCrosshairStyles.DEFAULT;
        @SerialEntry
        public boolean overrideColor = false;
        @SerialEntry
        public Color customColor = new Color(-5588020, true);
        @SerialEntry
        public boolean enableBlend = true;
        @SerialEntry
        public boolean coalesce = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CrosshairStyleSettings that = (CrosshairStyleSettings)o;
            return this.overrideColor == that.overrideColor && this.enableBlend == that.enableBlend && this.coalesce == that.coalesce && Objects.equals(this.style, that.style) && Objects.equals(this.customColor, that.customColor);
        }

        public int hashCode() {
            return Objects.hash(this.style, this.overrideColor, this.customColor, this.enableBlend, this.coalesce);
        }
    }

    public static class BlockCrosshairActivePredicate
    implements EnableIf.Predicate {
        public boolean test(Object value) {
            return value != BlockCrosshairPolicy.Disabled;
        }
    }
}

