/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config.gui;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import java.util.ArrayList;
import java.util.List;
import mod.crend.dynamiccrosshair.config.gui.CrosshairButton;
import mod.crend.dynamiccrosshair.config.gui.DrawCrosshairWidget;
import mod.crend.dynamiccrosshair.config.gui.SelectCrosshairController;
import mod.crend.dynamiccrosshair.style.AbstractCrosshairStyle;
import mod.crend.dynamiccrosshair.style.CrosshairStyleManager;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SelectCrosshairElement
extends AbstractWidget
implements ContainerEventHandler {
    static final int BUTTON_SIZE = 23;
    static final int BUTTON_SPACING = 25;
    static final int BUTTONS_PER_ROW = 9;
    static final int BIG_BUTTON_WIDTH = 45;
    final SelectCrosshairController control;
    GuiEventListener focusedElement;
    boolean dragging;
    int normalHeight;
    List<GuiEventListener> childrenInSelectMode = new ArrayList<GuiEventListener>();
    List<GuiEventListener> childrenInEditMode = new ArrayList<GuiEventListener>();
    List<Renderable> drawableInSelectMode = new ArrayList<Renderable>();
    List<Renderable> drawableInEditMode = new ArrayList<Renderable>();
    Button addButton;
    Button editButton;
    Button deleteButton;
    Button saveButton;
    Button cancelButton;
    DrawCrosshairWidget drawCrosshairWidget;

    public boolean canReset() {
        return true;
    }

    public SelectCrosshairElement(SelectCrosshairController selectCrosshairController, Dimension<Integer> widgetDimension) {
        super(widgetDimension);
        this.normalHeight = (Integer)widgetDimension.height();
        this.control = selectCrosshairController;
        this.createButtons();
        this.toggleButtons();
        this.updateFromSelectedStyle((ResourceLocation)this.control.option().pendingValue());
        this.control.option().addListener((opt, style) -> this.updateFromSelectedStyle((ResourceLocation)style));
    }

    private <T extends GuiEventListener & Renderable> void addSelectModeChild(T element) {
        this.childrenInSelectMode.add(element);
        this.drawableInSelectMode.add(element);
    }

    private <T extends GuiEventListener & Renderable> void addEditModeChild(T element) {
        this.childrenInEditMode.add(element);
        this.drawableInEditMode.add(element);
    }

    private <T extends GuiEventListener & Renderable> void addChild(T element) {
        this.addSelectModeChild(element);
        this.addEditModeChild(element);
    }

    private void createButtons() {
        int x = (Integer)this.getDimension().x();
        int y = (Integer)this.getDimension().y() + 25 + 2;
        this.addButton = Button.builder((Component)Component.translatable((String)"dynamiccrosshair.add"), button -> {
            this.control.add();
            this.toggleButtons();
        }).bounds(x, y, 43, 20).build();
        this.editButton = Button.builder((Component)Component.translatable((String)"dynamiccrosshair.edit"), button -> {
            if (this.control.isCustomStyle()) {
                this.control.edit();
                this.toggleButtons();
            }
        }).bounds(x + 45, y, 43, 20).build();
        this.deleteButton = Button.builder((Component)Component.translatable((String)"dynamiccrosshair.delete"), button -> {
            if (this.control.isCustomStyle()) {
                this.control.delete();
                this.toggleButtons();
            }
        }).bounds(x + 90, y, 43, 20).build();
        this.saveButton = Button.builder((Component)Component.translatable((String)"dynamiccrosshair.save"), button -> {
            this.control.save();
            this.toggleButtons();
        }).bounds(x + 135, y, 43, 20).build();
        this.cancelButton = Button.builder((Component)Component.translatable((String)"dynamiccrosshair.cancel"), button -> {
            this.control.cancel();
            this.toggleButtons();
        }).bounds(x + 180, y, 43, 20).build();
    }

    private void resetButtons() {
        this.childrenInSelectMode.clear();
        this.childrenInEditMode.clear();
        this.drawableInSelectMode.clear();
        this.drawableInEditMode.clear();
        this.addChild(this.addButton);
        this.addChild(this.editButton);
        this.addChild(this.deleteButton);
        this.addChild(this.saveButton);
        this.addChild(this.cancelButton);
        List<AbstractCrosshairStyle> styles = this.control.getButtons();
        int n = 2 + styles.size() / 9 + (styles.size() % 9 == 0 ? 0 : 1);
        this.setDimension(this.getDimension().withHeight((Number)(this.normalHeight * n)));
        int x = (Integer)this.getDimension().x();
        int y = 50;
        this.drawCrosshairWidget = new DrawCrosshairWidget((Dimension<Integer>)Dimension.ofInt((int)(x + 90), (int)(y + 10), (int)45, (int)45), this.control);
        this.addEditModeChild(this.drawCrosshairWidget);
        int buttonI = 0;
        for (AbstractCrosshairStyle style : styles) {
            this.addSelectModeChild(new CrosshairButton(this.control, style, (Dimension<Integer>)Dimension.ofInt((int)x, (int)y, (int)23, (int)23)));
            x += 25;
            if (++buttonI != 9) continue;
            buttonI = 0;
            x = (Integer)this.getDimension().x();
            y += 25;
        }
    }

    public void toggleButtons() {
        boolean canEditSelectedStyle;
        this.resetButtons();
        boolean editMode = this.control.editStyle != null;
        this.addButton.active = !editMode;
        this.editButton.active = canEditSelectedStyle = !editMode && CrosshairStyleManager.INSTANCE.isCustomStyle((ResourceLocation)this.control.option.pendingValue());
        this.deleteButton.active = canEditSelectedStyle;
        this.saveButton.active = editMode;
        this.cancelButton.active = editMode;
    }

    public void updateFromSelectedStyle(ResourceLocation identifier) {
        boolean isCustomStyle;
        this.editButton.active = isCustomStyle = CrosshairStyleManager.INSTANCE.isCustomStyle(identifier);
        this.deleteButton.active = isCustomStyle;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.control.editStyle == null) {
            for (Renderable drawable : this.drawableInSelectMode) {
                drawable.render(context, mouseX, mouseY, delta);
            }
        } else {
            for (Renderable drawable : this.drawableInEditMode) {
                drawable.render(context, mouseX, mouseY, delta);
            }
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.control.editStyle == null ? this.childrenInSelectMode : this.childrenInEditMode;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        int button = mouseButtonEvent.button();
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.mouseClicked(mouseButtonEvent, doubleClick)) continue;
            this.setFocused(guiEventListener);
            if (button == 0 || button == 1) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    public boolean mouseReleased(MouseButtonEvent mouseButtonEvent) {
        this.setDragging(false);
        return this.getChildAt(mouseButtonEvent.x(), mouseButtonEvent.y()).filter(element -> element.mouseReleased(mouseButtonEvent)).isPresent();
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dx, double dy) {
        return this.getFocused() != null && this.isDragging() && this.getFocused().mouseDragged(mouseButtonEvent, dx, dy);
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focusedElement;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.focusedElement != null) {
            this.focusedElement.setFocused(false);
        }
        if (focused != null) {
            focused.setFocused(true);
        }
        this.focusedElement = focused;
    }

    @Nullable
    public ComponentPath getCurrentFocusPath() {
        return super.getCurrentFocusPath();
    }

    @Nullable
    public ComponentPath nextFocusPath(FocusNavigationEvent navigation) {
        return super.nextFocusPath(navigation);
    }
}

