/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.block;

import mod.crend.dynamiccrosshair.mixin.DynamicCrosshairBaseBlock;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairBlock;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={SignBlock.class})
public abstract class AbstractSignBlockMixin
extends DynamicCrosshairBaseBlock
implements DynamicCrosshairBlock {
    public AbstractSignBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        BlockEntity blockEntity = context.getBlockEntity();
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
            Item handItem = context.getItem();
            SignText signText = signBlockEntity.getText(signBlockEntity.isFacingFrontText((Player)context.getPlayer()));
            if (signBlockEntity.isWaxed()) {
                if (signText.hasAnyClickCommands((Player)context.getPlayer())) {
                    return InteractionType.INTERACT_WITH_ENTITY;
                }
                return InteractionType.NO_ACTION;
            }
            if (handItem instanceof SignApplicator) {
                if (signText.hasMessage((Player)context.getPlayer())) {
                    if (handItem.equals(Items.GLOW_INK_SAC) && !signText.hasGlowingText()) {
                        return InteractionType.USE_ITEM_ON_ENTITY;
                    }
                    if (handItem.equals(Items.INK_SAC) && signText.hasGlowingText()) {
                        return InteractionType.USE_ITEM_ON_ENTITY;
                    }
                    if (handItem instanceof DyeItem) {
                        DyeItem dye = (DyeItem)handItem;
                        if (signText.getColor() != dye.getDyeColor()) {
                            return InteractionType.USE_ITEM_ON_ENTITY;
                        }
                    }
                }
                if (handItem.equals(Items.HONEYCOMB)) {
                    return InteractionType.USE_ITEM_ON_ENTITY;
                }
            }
            return InteractionType.INTERACT_WITH_ENTITY;
        }
        return super.dynamiccrosshair$compute(context);
    }
}

