/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.block;

import java.util.OptionalInt;
import mod.crend.dynamiccrosshair.mixin.DynamicCrosshairBaseBlock;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ShelfBlock.class})
public abstract class ShelfBlockMixin
extends DynamicCrosshairBaseBlock
implements SelectableSlotContainer,
DynamicCrosshairBlock {
    @Shadow
    @Final
    public static EnumProperty<Direction> FACING;
    @Shadow
    @Final
    public static BooleanProperty POWERED;

    public ShelfBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        OptionalInt optionalInt;
        if (context.isMainHand() && (optionalInt = this.getHitSlot(context.getBlockHitResult(), (Direction)context.getBlockState().getValue(FACING))).isPresent()) {
            BlockEntity blockEntity;
            if (context.getItemStack().isEmpty() && (blockEntity = context.getBlockEntity()) instanceof ShelfBlockEntity) {
                ShelfBlockEntity shelf = (ShelfBlockEntity)blockEntity;
                if (((Boolean)context.getBlockState().getValue((Property)POWERED)).booleanValue()) {
                    return InteractionType.TAKE_ITEM_FROM_BLOCK;
                }
                if (!shelf.getItem(optionalInt.getAsInt()).isEmpty()) {
                    return InteractionType.TAKE_ITEM_FROM_BLOCK;
                }
            } else {
                return InteractionType.PLACE_ITEM_ON_BLOCK;
            }
        }
        return InteractionType.EMPTY;
    }
}

