/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.mixin.entity;

import mod.crend.dynamiccrosshair.mixin.entity.MobEntityMixin;
import mod.crend.dynamiccrosshairapi.crosshair.CrosshairContext;
import mod.crend.dynamiccrosshairapi.interaction.InteractionType;
import mod.crend.dynamiccrosshairapi.type.DynamicCrosshairEntity;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.WeatheringCopper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={CopperGolem.class})
public abstract class CopperGolemEntityMixin
extends MobEntityMixin
implements Shearable,
DynamicCrosshairEntity {
    @Shadow
    private long nextWeatheringTick;

    @Shadow
    public abstract WeatheringCopper.WeatherState getWeatherState();

    @Override
    public InteractionType dynamiccrosshair$compute(CrosshairContext context) {
        ItemStack itemStack = context.getItemStack();
        if (itemStack.isEmpty() && !this.getMainHandItem().isEmpty()) {
            return InteractionType.TAKE_ITEM_FROM_ENTITY;
        }
        if (itemStack.is(Items.SHEARS) && this.readyForShearing()) {
            return InteractionType.USE_ITEM_ON_ENTITY;
        }
        if (itemStack.is(Items.HONEYCOMB) && this.nextWeatheringTick != -2L) {
            return InteractionType.USE_ITEM_ON_ENTITY;
        }
        if (itemStack.is(ItemTags.AXES) && (this.nextWeatheringTick == -2L || this.getWeatherState() != WeatheringCopper.WeatherState.UNAFFECTED)) {
            return InteractionType.USE_ITEM_ON_ENTITY;
        }
        return super.dynamiccrosshair$compute(context);
    }
}

