/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.style;

import it.unimi.dsi.fastutil.io.FastByteArrayInputStream;
import it.unimi.dsi.fastutil.io.FastByteArrayOutputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import mod.crend.dynamiccrosshair.style.AbstractCrosshairStyle;
import mod.crend.dynamiccrosshair.style.BuiltinCrosshairStyle;
import mod.crend.dynamiccrosshair.style.CustomCrosshairStyle;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import mod.crend.libbamboo.PlatformUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CrosshairStyleManager {
    public static final CrosshairStyleManager INSTANCE = new CrosshairStyleManager();
    public static final class_1060 textureManager = class_310.method_1551().method_1531();
    public static final Path crosshairDirectory = PlatformUtils.resolveConfigFile((String)"crosshairs");
    Map<class_2960, CustomCrosshairStyle> styles = new LinkedHashMap<class_2960, CustomCrosshairStyle>();

    private CrosshairStyleManager() {
    }

    public void init() {
        File directory = crosshairDirectory.toFile();
        directory.mkdirs();
        for (File file : Objects.requireNonNull(directory.listFiles())) {
            this.registerCustomCrosshair(file);
        }
    }

    public boolean has(class_2960 identifier) {
        return this.styles.containsKey(identifier);
    }

    public boolean isCustomStyle(class_2960 identifier) {
        return this.has(identifier) && this.get(identifier).isCustom();
    }

    public AbstractCrosshairStyle get(class_2960 identifier) {
        if (BuiltinCrosshairStyle.BUILTIN_STYLES.containsKey(identifier)) {
            return BuiltinCrosshairStyle.BUILTIN_STYLES.get(identifier);
        }
        if (this.has(identifier)) {
            return this.styles.get(identifier);
        }
        return new CustomCrosshairStyle(identifier, "unknown");
    }

    public CustomCrosshairStyle getCustomStyle(class_2960 identifier) {
        return this.styles.get(identifier);
    }

    public Collection<BuiltinCrosshairStyle> getBuiltinStyles() {
        return BuiltinCrosshairStyle.BUILTIN_STYLES.values();
    }

    public Collection<CustomCrosshairStyle> getCustomStyles() {
        return this.styles.values();
    }

    public void delete(class_2960 identifier) {
        if (this.has(identifier)) {
            File file = crosshairDirectory.resolve(this.styles.get(identifier).getName() + ".png").toFile();
            file.delete();
        }
        this.remove(identifier);
    }

    public void remove(class_2960 identifier) {
        this.styles.remove(identifier);
    }

    public CustomCrosshairStyle create() {
        String name = this.getFirstUnusedName();
        class_2960 identifier = DynamicCrosshairStyles.of((String)("custom-" + name));
        CustomCrosshairStyle style = new CustomCrosshairStyle(identifier, name);
        this.styles.put(identifier, style);
        return style;
    }

    private String getFirstUnusedName() {
        int i = 0;
        while (crosshairDirectory.resolve(++i + ".png").toFile().exists()) {
        }
        return Integer.toString(i);
    }

    private void registerCustomCrosshair(File file) {
        String name = file.getName().split("\\.")[0];
        class_2960 identifier = DynamicCrosshairStyles.of((String)("custom-" + name));
        this.styles.put(identifier, new CustomCrosshairStyle(identifier, name));
        try {
            class_1011 nativeImage = class_1011.method_4309((InputStream)new FileInputStream(file));
            textureManager.method_4616(identifier, (class_1044)new class_1043(nativeImage));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(CustomCrosshairStyle style, BufferedImage image) {
        this.styles.put(style.identifier, style);
        File file = crosshairDirectory.resolve(style.getName() + ".png").toFile();
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean reload(CustomCrosshairStyle editStyle) {
        try {
            File file = crosshairDirectory.resolve(editStyle.name + ".png").toFile();
            if (file.exists()) {
                class_1011 nativeImage = class_1011.method_4309((InputStream)new FileInputStream(file));
                textureManager.method_4616(editStyle.identifier, (class_1044)new class_1043(nativeImage));
                return true;
            }
            textureManager.method_4615(editStyle.identifier);
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void registerTexture(BufferedImage editImage, class_2960 identifier) {
        try (FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();){
            ImageIO.write((RenderedImage)editImage, "PNG", (OutputStream)outputStream);
            class_1011 nativeImage = class_1011.method_4309((InputStream)new FastByteArrayInputStream(outputStream.array));
            textureManager.method_4616(identifier, (class_1044)new class_1043(nativeImage));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public class_1011 getTexture(class_2960 identifier) {
        return ((class_1043)textureManager.method_4619(identifier)).method_4525();
    }
}

