/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshairapi.crosshair;

import mod.crend.dynamiccrosshairapi.interaction.InteractionType;

public record Crosshair(InteractionType primaryInteraction, InteractionType secondaryInteraction) {
    public Crosshair() {
        this(InteractionType.EMPTY, InteractionType.EMPTY);
    }

    public Crosshair(InteractionType interactionType) {
        this(interactionType.getPrimaryInteractionType(), interactionType.getSecondaryInteractionType());
    }

    public Crosshair combine(Crosshair other) {
        if (other == null) {
            return this;
        }
        InteractionType newPrimaryInteraction = this.primaryInteraction;
        InteractionType newSecondaryInteraction = this.secondaryInteraction;
        if (this.primaryInteraction == InteractionType.EMPTY) {
            if (other.primaryInteraction() != InteractionType.EMPTY) {
                newPrimaryInteraction = other.primaryInteraction();
            }
        } else if (this.primaryInteraction == InteractionType.TOOL && (other.primaryInteraction() == InteractionType.CORRECT_TOOL || other.primaryInteraction() == InteractionType.INCORRECT_TOOL)) {
            newPrimaryInteraction = other.primaryInteraction();
        }
        if (this.secondaryInteraction == InteractionType.EMPTY) {
            if (other.secondaryInteraction() != InteractionType.EMPTY) {
                newSecondaryInteraction = other.secondaryInteraction();
            }
        } else if (other.secondaryInteraction == InteractionType.RANGED_WEAPON_CHARGING || other.secondaryInteraction == InteractionType.RANGED_WEAPON_CHARGED) {
            newSecondaryInteraction = other.secondaryInteraction;
        }
        return new Crosshair(newPrimaryInteraction, newSecondaryInteraction);
    }

    public boolean hasInteraction() {
        return this.primaryInteraction != InteractionType.EMPTY || this.secondaryInteraction != InteractionType.EMPTY;
    }

    public static Crosshair combine(Crosshair one, Crosshair other) {
        if (one == null) {
            return other == null ? new Crosshair() : other;
        }
        return one.combine(other);
    }

    public boolean hasPrimaryInteraction() {
        return this.primaryInteraction != InteractionType.EMPTY;
    }

    public boolean hasSecondaryInteraction() {
        return this.secondaryInteraction != InteractionType.EMPTY;
    }

    @Override
    public String toString() {
        return "Crosshair{primaryInteraction=" + String.valueOf((Object)this.primaryInteraction) + ", secondaryInteraction=" + String.valueOf((Object)this.secondaryInteraction) + "}";
    }
}

