/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils;

import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.utility.StringUtility;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public class EventInfoScreen
extends class_437 {
    private static final int BOX_WIDTH = 350;
    private static final int BOX_HEIGHT = 280;
    @NotNull
    private final JsonObject json;

    public EventInfoScreen(@NotNull JsonObject json) {
        super((class_2561)class_2561.method_43471((String)EventUtils.MOD.keybindManager.eventInfoKey.method_1431()));
        this.json = json;
    }

    public void method_25394(class_332 drawContext, int i, int j, float f) {
        int boxX = (this.field_22789 - 350) / 2;
        int boxY = (this.field_22790 - 280) / 2;
        int startX = boxX + 175;
        int startY = boxY + 5;
        drawContext.method_25294(boxX, boxY, boxX + 350, boxY + 280, -2013265920);
        class_327 textRenderer = class_310.method_1551().field_1772;
        for (Map.Entry entry : this.json.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement jsonValue = (JsonElement)entry.getValue();
            String value = jsonValue.isJsonArray() ? this.formatList(jsonValue.getAsJsonArray()) : (jsonValue.isJsonPrimitive() ? jsonValue.getAsString() : jsonValue.toString());
            if (key.equals("time") || key.equals("created")) {
                value = this.formatTime(value);
            }
            drawContext.method_25300(textRenderer, StringUtility.capitalize(key) + ": " + value, startX, startY, 0xFFFFFF);
            startY += 12;
        }
    }

    @NotNull
    private String formatTime(@NotNull String unixTimestamp) {
        long seconds;
        Instant timestamp;
        unixTimestamp = unixTimestamp.replaceAll("\"", "");
        try {
            timestamp = Instant.ofEpochMilli(Long.parseLong(unixTimestamp));
        }
        catch (Exception e) {
            EventUtils.LOGGER.warn("Failed to parse timestamp: {}", (Object)unixTimestamp, (Object)e);
            return unixTimestamp;
        }
        Instant now = Instant.now();
        long timestampSeconds = timestamp.getEpochSecond();
        long nowSeconds = now.getEpochSecond();
        if (timestampSeconds == nowSeconds) {
            return "now";
        }
        StringBuilder builder = new StringBuilder();
        if (timestampSeconds > nowSeconds) {
            builder.append("in ");
        }
        if ((seconds = Duration.between(timestamp, now).getSeconds()) < 60L) {
            builder.append(seconds).append(" seconds");
        } else if (seconds < 3600L) {
            builder.append(Math.ceil((double)seconds / 60.0)).append(" minutes");
        } else if (seconds < 86400L) {
            builder.append(Math.ceil((double)seconds / 3600.0)).append(" hours");
        } else {
            builder.append(Math.ceil((double)seconds / 86400.0)).append(" days");
        }
        if (timestampSeconds < nowSeconds) {
            builder.append(" ago");
        }
        return builder.toString();
    }

    @NotNull
    private String formatList(@NotNull JsonArray list) {
        int size = list.size();
        if (size == 0) {
            return "";
        }
        if (size == 1) {
            return list.get(0).toString();
        }
        StringBuilder builder = new StringBuilder();
        for (JsonElement element : list) {
            builder.append(element).append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }
}

