/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils;

import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.Versions;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class UpdateChecker {
    @NotNull
    private final EventUtils mod;

    public UpdateChecker(@NotNull EventUtils mod) {
        this.mod = mod;
    }

    private void notifyUpdate(@NotNull String latestVersion) {
        class_310 client = class_310.method_1551();
        client.method_63588(() -> {
            if (client.field_1724 == null) {
                return;
            }
            client.field_1724.method_7353((class_2561)EventUtils.MESSAGE_PREFIX.method_27661().method_27693(" \u00a7e" + EventUtils.translate("eventutils.updatechecker.new") + "\u00a7r \u00a77(v" + Versions.EU_VERSION + " -> v" + latestVersion.replace(Versions.MC_VERSION + "-", "") + ")\n").method_10862(EventUtils.MESSAGE_PREFIX.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"eventutils.updatechecker.hover"))).method_10958((class_2558)new class_2558.class_10608(URI.create("https://modrinth.com/mod/alerts/version/" + latestVersion)))).method_10852((class_2561)class_2561.method_43470((String)("\u00a77\u00a7o" + EventUtils.translate("eventutils.updatechecker.config"))).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10609("/event utils")))), false);
        });
    }

    public void checkUpdate() {
        try {
            if (!this.mod.config.updateChecker || Versions.MC_VERSION == null || Versions.EU_VERSION == null || Versions.EU_VERSION_SEMANTIC == null) {
                return;
            }
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            HttpClient httpClient = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.modrinth.com/v2/project/alerts/version?game_versions=%5B%22" + Versions.MC_VERSION + "%22%5D")).header("User-Agent", "EventUtils/" + Versions.EU_VERSION + " (Minecraft/" + Versions.MC_VERSION + ")").build();
            ((CompletableFuture)((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(body -> {
                try {
                    JsonObject latestVersionObj = JsonParser.parseString((String)body).getAsJsonArray().get(0).getAsJsonObject();
                    if (latestVersionObj == null || !latestVersionObj.has("version_number")) {
                        EventUtils.LOGGER.error("Failed to check for updates: Unexpected response from Modrinth");
                        return;
                    }
                    String latestVersion = latestVersionObj.get("version_number").getAsString();
                    String currentVersion = Versions.MC_VERSION + "-" + Versions.EU_VERSION;
                    if (!currentVersion.equals(latestVersion)) {
                        this.notifyUpdate(latestVersion);
                    }
                }
                catch (Exception e) {
                    EventUtils.LOGGER.error("Failed to parse update check:", (Throwable)e);
                }
            })).exceptionally(e -> {
                EventUtils.LOGGER.error("Failed to check for updates", e);
                return null;
            });
        }
        catch (Exception e2) {
            EventUtils.LOGGER.warn("Failed to check for updates", (Throwable)e2);
        }
    }
}

