/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.config.adapters;

import cc.aabss.eventutils.EventType;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EventTypeSetAdapter
extends TypeAdapter<Set<EventType>> {
    public void write(@NotNull JsonWriter out, @NotNull Set<EventType> value) throws IOException {
        out.beginArray();
        for (EventType type : value) {
            out.value(type.name());
        }
        out.endArray();
    }

    @NotNull
    public Set<EventType> read(@NotNull JsonReader in) throws IOException {
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        in.beginArray();
        while (in.hasNext()) {
            EventType type = EventType.fromString(in.nextString());
            if (type == null) continue;
            eventTypes.add(type);
        }
        in.endArray();
        return eventTypes;
    }
}

