/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.websocket;

import cc.aabss.eventutils.EventType;
import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.utility.ConnectUtility;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SocketEndpoint {
    EVENT_POSTED((mod, message) -> {
        JsonObject json = SocketEndpoint.parseJson(message);
        if (json == null) {
            return;
        }
        for (EventType eventType : EventType.fromJson(json)) {
            if (!mod.config.eventTypes.contains((Object)eventType)) continue;
            LAST_EVENT = json;
            String ip = mod.getIpAndConnect(eventType, json);
            int prizeAmount = eventType == EventType.MONEY ? SocketEndpoint.prize(json) : 0;
            eventType.sendToast((EventUtils)mod, prizeAmount > 0 ? Integer.valueOf(prizeAmount) : null, ip != null && !ip.isEmpty());
            mod.lastIps.put(eventType, ip);
            if (ip == null || ip.isEmpty()) continue;
            try {
                mod.eventServerManager.addEventServer(json, ip);
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to add event server to server list: {}", (Object)json, (Object)e);
            }
        }
    }),
    FAMOUS_EVENT_POSTED((mod, message) -> {
        JsonObject json = SocketEndpoint.parseJson(message);
        if (json == null) {
            return;
        }
        EventType eventType = EventType.valueOf(json.get("type").getAsString());
        if (eventType.equals((Object)EventType.FAMOUS) && json.get("channel").getAsString().equals("1006347642500022353")) {
            eventType = EventType.SKEPPY;
        }
        if (!mod.config.eventTypes.contains((Object)eventType)) {
            return;
        }
        LAST_EVENT = json;
        String ip = mod.getIpAndConnect(eventType, json);
        eventType.sendToast((EventUtils)mod, null, ip != null && !ip.isEmpty());
        mod.lastIps.put(eventType, mod.getIpAndConnect(eventType, json));
    }),
    EVENT_CANCELLED((mod, message) -> {
        String eventId;
        JsonObject json = SocketEndpoint.parseJson(message);
        if (json == null) {
            return;
        }
        if (!json.has("id")) {
            return;
        }
        try {
            eventId = json.get("id").getAsString();
        }
        catch (Exception e) {
            EventUtils.LOGGER.warn("Failed to parse ID from cancellation event: {}", (Object)json, (Object)e);
            return;
        }
        try {
            mod.eventServerManager.removeEventServer(eventId);
        }
        catch (Exception e) {
            EventUtils.LOGGER.warn("Failed to remove event server from server list: {}", (Object)json, (Object)e);
        }
    });

    @Nullable
    public static JsonObject LAST_EVENT;
    @NotNull
    public final BiConsumer<EventUtils, String> handler;

    private SocketEndpoint(BiConsumer<EventUtils, String> handler) {
        this.handler = handler;
    }

    @Nullable
    private static JsonObject parseJson(@NotNull String message) {
        try {
            return JsonParser.parseString((String)message).getAsJsonObject();
        }
        catch (Exception e) {
            EventUtils.LOGGER.error("Failed to parse JSON: {}", (Object)message);
            return null;
        }
    }

    private static int prize(@NotNull JsonObject event) {
        JsonElement prize = event.get("prize");
        if (prize != null) {
            return Integer.parseInt(prize.getAsString().replaceAll("[$\u20ac\u00a3]", "").split(" ")[0]);
        }
        JsonElement description = event.get("description");
        if (description == null) {
            return 0;
        }
        for (String line : ConnectUtility.removeMarkdown(description.getAsString().toLowerCase()).split("\\n+")) {
            if (!line.contains("$") && !line.contains("\u20ac") && !line.contains("\u00a3") && !line.contains("dollars") && !line.contains("prize")) continue;
            for (String word : line.split(" ")) {
                if (word.contains("$") || word.contains("\u20ac") || word.contains("\u00a3")) {
                    word = word.replaceAll("[$\u20ac\u00a3]", "");
                }
                try {
                    return Integer.parseInt(word);
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return 0;
    }
}

