/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils;

import cc.aabss.eventutils.EventUtils;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import net.minecraft.class_641;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventServerManager {
    public static final String EVENT_SERVER_PREFIX = "\u00a77[Event] \u00a7r";
    @NotNull
    private final EventUtils mod;
    @NotNull
    private final Map<String, EventServerInfo> activeEventServers = new HashMap<String, EventServerInfo>();
    @NotNull
    private final Map<String, ScheduledFuture<?>> removalTasks = new HashMap();
    @Nullable
    private class_641 serverList;

    public EventServerManager(@NotNull EventUtils mod) {
        this.mod = mod;
    }

    public void setServerList(@Nullable class_641 serverList) {
        this.serverList = serverList;
    }

    public void addEventServer(@NotNull JsonObject eventJson, @NotNull String ip) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        Object eventId = "event-" + System.currentTimeMillis();
        if (eventJson.has("id")) {
            try {
                String idJson = eventJson.get("id").getAsString();
                if (idJson != null && !idJson.isEmpty()) {
                    eventId = idJson;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse ID from event: {}", (Object)eventJson, (Object)e);
            }
        }
        String finalEventId = eventId;
        if (this.activeEventServers.containsKey(eventId)) {
            return;
        }
        String title = "Event";
        if (eventJson.has("title")) {
            try {
                String titleJson = eventJson.get("title").getAsString();
                if (titleJson != null && !titleJson.isEmpty()) {
                    title = titleJson;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse title from event: {}", (Object)eventJson, (Object)e);
            }
        }
        String finalTitle = title;
        long eventTime = System.currentTimeMillis();
        if (eventJson.has("time")) {
            try {
                long eventTimeJson = eventJson.get("time").getAsLong();
                if (eventTimeJson > 0L) {
                    eventTime = eventTimeJson;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse time from event: {}", (Object)eventJson, (Object)e);
            }
        }
        long finalEventTime = eventTime;
        client.execute(() -> {
            if (!this.ensureServerListLoaded()) {
                EventUtils.LOGGER.warn("Server list not available, cannot add event server");
                return;
            }
            if (this.serverList == null) {
                return;
            }
            String serverName = EVENT_SERVER_PREFIX + finalTitle;
            class_642 serverInfo = new class_642(serverName, ip, class_642.class_8678.field_45611);
            serverInfo.method_2995(class_642.class_643.field_3767);
            for (int i = 0; i < this.serverList.method_2984(); ++i) {
                class_642 existing = this.serverList.method_2982(i);
                if (!existing.field_3752.equals(serverName) || !existing.field_3761.equalsIgnoreCase(ip)) continue;
                EventUtils.LOGGER.info("Event server already present in server list: '{}' -> '{}'", (Object)serverName, (Object)ip);
                return;
            }
            this.serverList.method_2988(serverInfo, false);
            EventServerInfo eventServerInfo = new EventServerInfo(finalEventId, serverInfo, finalEventTime);
            this.activeEventServers.put(finalEventId, eventServerInfo);
            long currentTime = System.currentTimeMillis();
            long graceMs = TimeUnit.MINUTES.toMillis(5L);
            long timeUntilRemoval = finalEventTime + graceMs - currentTime;
            if (timeUntilRemoval > 0L) {
                ScheduledFuture<?> removalTask = this.mod.scheduler.schedule(() -> this.removeEventServer(finalEventId), timeUntilRemoval, TimeUnit.MILLISECONDS);
                this.removalTasks.put(finalEventId, removalTask);
                EventUtils.LOGGER.info("Scheduled removal of event server '{}' in {} ms (5m after start)", (Object)finalTitle, (Object)timeUntilRemoval);
            } else if (currentTime - finalEventTime <= graceMs) {
                long remaining = graceMs - (currentTime - finalEventTime);
                ScheduledFuture<?> removalTask = this.mod.scheduler.schedule(() -> this.removeEventServer(finalEventId), remaining, TimeUnit.MILLISECONDS);
                this.removalTasks.put(finalEventId, removalTask);
                EventUtils.LOGGER.info("Event '{}' already started; keeping for {} ms (grace)", (Object)finalTitle, (Object)remaining);
            } else {
                this.serverList.method_2983(serverInfo);
                this.activeEventServers.remove(finalEventId);
                EventUtils.LOGGER.info("Event '{}' started more than 5 minutes ago; not adding", (Object)finalTitle);
                return;
            }
            try {
                this.serverList.method_2987();
            }
            catch (Exception e) {
                EventUtils.LOGGER.error("Failed to save server list after adding event server", (Throwable)e);
            }
            EventUtils.LOGGER.info("Added event server '{}' with IP '{}' to server list", (Object)finalTitle, (Object)ip);
        });
    }

    public void removeEventServer(@NotNull String eventId) {
        class_310 client = class_310.method_1551();
        if (client != null) {
            client.execute(() -> {
                ScheduledFuture<?> removalTask;
                EventServerInfo eventServerInfo = this.activeEventServers.remove(eventId);
                if (eventServerInfo == null) {
                    return;
                }
                if (!this.ensureServerListLoaded()) {
                    EventUtils.LOGGER.warn("Server list not available, cannot remove event server");
                    return;
                }
                if (this.serverList == null) {
                    return;
                }
                int removedCount = 0;
                for (int i = this.serverList.method_2984() - 1; i >= 0; --i) {
                    class_642 candidate = this.serverList.method_2982(i);
                    if (!candidate.field_3752.equals(eventServerInfo.serverInfo.field_3752) || !candidate.field_3761.equalsIgnoreCase(eventServerInfo.serverInfo.field_3761)) continue;
                    this.serverList.method_2983(candidate);
                    ++removedCount;
                }
                if (removedCount == 0) {
                    EventUtils.LOGGER.warn("Event server not found in current server list for removal: '{}' -> '{}'", (Object)eventServerInfo.serverInfo.field_3752, (Object)eventServerInfo.serverInfo.field_3761);
                }
                if ((removalTask = this.removalTasks.remove(eventId)) != null) {
                    removalTask.cancel(false);
                }
                try {
                    this.serverList.method_2987();
                }
                catch (Exception e) {
                    EventUtils.LOGGER.error("Failed to save server list after removing event server", (Throwable)e);
                }
                EventUtils.LOGGER.info("Removed event server from server list: {}", (Object)eventServerInfo.serverInfo.field_3752);
            });
        }
    }

    public void removeAllEventServers() {
        this.removalTasks.values().forEach(task -> task.cancel(false));
        this.removalTasks.clear();
        for (String eventId : new HashMap<String, EventServerInfo>(this.activeEventServers).keySet()) {
            this.removeEventServer(eventId);
        }
    }

    public int getActiveEventCount() {
        return this.activeEventServers.size();
    }

    private boolean ensureServerListLoaded() {
        if (this.serverList != null) {
            return true;
        }
        class_310 client = class_310.method_1551();
        if (client == null) {
            return false;
        }
        this.serverList = new class_641(client);
        try {
            this.serverList.method_2981();
        }
        catch (Exception e) {
            EventUtils.LOGGER.error("Failed to load server list from file", (Throwable)e);
        }
        return true;
    }

    private static class EventServerInfo {
        @NotNull
        public final String eventId;
        @NotNull
        public final class_642 serverInfo;
        public final long eventTime;

        public EventServerInfo(@NotNull String eventId, @NotNull class_642 serverInfo, long eventTime) {
            this.eventId = eventId;
            this.serverInfo = serverInfo;
            this.eventTime = eventTime;
        }
    }
}

