/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils;

import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.NotificationToast;
import cc.aabss.eventutils.config.ConfigScreen;
import cc.aabss.eventutils.config.EventConfig;
import cc.aabss.eventutils.config.NotificationSound;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.controller.EnumDropdownControllerBuilder;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EventType {
    SKEPPY("eventutils.skeppy.display", class_2561.method_43471((String)"eventutils.skeppy.new").method_27692(class_124.field_1075)),
    POTENTIAL_FAMOUS("eventutils.potential_famous.display", class_2561.method_43471((String)"eventutils.potential_famous.new").method_27692(class_124.field_1062)),
    SIGHTING("eventutils.sighting.display", class_2561.method_43471((String)"eventutils.sighting.new").method_27692(class_124.field_1079)),
    FAMOUS("eventutils.famous.display", class_2561.method_43471((String)"eventutils.famous.new").method_27692(class_124.field_1075)),
    PARTNER("eventutils.partner.display", class_2561.method_43471((String)"eventutils.partner.new").method_27692(class_124.field_1076)),
    COMMUNITY("eventutils.community.display", class_2561.method_43471((String)"eventutils.community.new").method_27692(class_124.field_1080)),
    MONEY("eventutils.money.display", prize -> {
        class_5250 text = class_2561.method_43471((String)"eventutils.money.new").method_27692(class_124.field_1060);
        if (prize != null && prize > 0) {
            text.method_10852((class_2561)class_2561.method_43470((String)(" ($" + prize + ")")).method_27692(class_124.field_1080));
        }
        return text;
    }),
    FUN("eventutils.fun.display", class_2561.method_43471((String)"eventutils.fun.new").method_27692(class_124.field_1061)),
    HOUSING("eventutils.housing.display", class_2561.method_43471((String)"eventutils.housing.new").method_27692(class_124.field_1065)),
    CIVILIZATION("eventutils.civilization.display", class_2561.method_43471((String)"eventutils.civilization.new").method_27692(class_124.field_1078));

    @NotNull
    public final class_5250 displayName;
    @NotNull
    public final String displayNameString;
    @NotNull
    public final Function<Integer, class_5250> toast;

    private EventType(String translateKey, Function<Integer, class_5250> toast) {
        this.displayName = class_2561.method_43471((String)translateKey);
        this.displayNameString = this.name().toLowerCase().replace("_", "");
        this.toast = toast;
    }

    private EventType(String displayName, class_5250 toast) {
        this(displayName, (Integer prize) -> toast);
    }

    @NotNull
    public Option<Boolean> getOption(@NotNull EventConfig config) {
        return Option.createBuilder().name((class_2561)this.displayName).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)EventUtils.translate("eventutils.config.event_description").replace("{event}", this.displayName.getString()))})).binding((Object)true, () -> config.eventTypes.contains((Object)this), newValue -> {
            if (newValue.booleanValue()) {
                config.eventTypes.add(this);
            } else {
                config.eventTypes.remove((Object)this);
            }
            config.setSave("notifications", config.eventTypes);
        }).controller(ConfigScreen::getBooleanBuilder).build();
    }

    @NotNull
    public Option<NotificationSound> getSoundOption(@NotNull EventConfig config) {
        return Option.createBuilder().name((class_2561)this.displayName).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)EventUtils.translate("eventutils.config.sound_description").replace("{event}", this.displayName.getString()))})).binding((Object)EventConfig.Defaults.notificationSounds().get((Object)this), () -> config.notificationSounds.get((Object)this), newValue -> {
            config.notificationSounds.put(this, (NotificationSound)((Object)newValue));
            config.setSave("notification_sounds", config.notificationSounds);
        }).controller(EnumDropdownControllerBuilder::create).addListener((option, event) -> {
            if (event == OptionEventListener.Event.STATE_CHANGE) {
                ((NotificationSound)((Object)((Object)option.pendingValue()))).play();
            }
        }).build();
    }

    public void sendToast(@NotNull EventUtils mod, @Nullable Integer prize, boolean hasIp) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_5250 description = null;
        if (hasIp) {
            String[] split = EventUtils.translate("eventutils.event.teleport").split("\\{command}");
            description = class_2561.method_43470((String)split[0]).method_27692(class_124.field_1068).method_27693("/eventutils teleport " + this.name().toLowerCase()).method_27692(class_124.field_1054).method_27693(split[1]).method_27692(class_124.field_1068);
        }
        client.method_1566().method_1999((class_368)new NotificationToast((class_2561)this.toast.apply(prize), (class_2561)description, client.field_1724 != null));
        mod.config.getNotificationSound(this).play();
    }

    @Nullable
    public static EventType fromString(@NotNull String eventType) {
        try {
            return EventType.valueOf(eventType.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            EventUtils.LOGGER.warn("Invalid event type: {}", (Object)eventType);
            return null;
        }
    }

    @NotNull
    public static Set<EventType> fromJson(@NotNull JsonObject json) {
        HashSet<EventType> eventTypes = new HashSet<EventType>();
        JsonArray roles = json.getAsJsonArray("rolesNamed");
        if (roles != null) {
            for (JsonElement role : roles) {
                EventType eventType = EventType.fromString(role.getAsString());
                if (eventType == null) continue;
                eventTypes.add(eventType);
            }
        }
        return eventTypes;
    }
}

