/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.utility;

import cc.aabss.eventutils.EventUtils;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectUtility {
    public static void connect(@NotNull String ip) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        class_642 currentServer = client.method_1558();
        if (currentServer != null && currentServer.field_3761.equalsIgnoreCase(ip)) {
            return;
        }
        class_442 screen = new class_442();
        class_639 address = class_639.method_2950((String)ip);
        client.execute(() -> {
            try {
                client.method_18099();
                class_412.method_36877((class_437)screen, (class_310)client, (class_639)address, (class_642)new class_642("EventUtils Event Server", ip, class_642.class_8678.field_45611), (boolean)true);
            }
            catch (Exception e) {
                EventUtils.LOGGER.error("Failed to connect to server: {}", (Object)e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Nullable
    public static String extractIp(@NotNull JsonObject eventJson) {
        String extracted;
        if (eventJson.has("ip")) {
            try {
                String ip = eventJson.get("ip").getAsString();
                if (ip != null && !ip.isEmpty()) {
                    return ip;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse ip from event: {}", (Object)eventJson, (Object)e);
            }
        }
        if (eventJson.has("description")) {
            try {
                String description = eventJson.get("description").getAsString();
                extracted = ConnectUtility.getIp(description);
                if (extracted != null && !extracted.isEmpty()) {
                    return extracted;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse description for IP from event: {}", (Object)eventJson, (Object)e);
            }
        }
        if (eventJson.has("title")) {
            try {
                String title = eventJson.get("title").getAsString();
                extracted = ConnectUtility.getIp(title);
                if (extracted != null && !extracted.isEmpty()) {
                    return extracted;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse title for IP from event: {}", (Object)eventJson, (Object)e);
            }
        }
        if (eventJson.has("address")) {
            try {
                String address = eventJson.get("address").getAsString();
                if (address != null && !address.isEmpty()) {
                    return address;
                }
            }
            catch (Exception e) {
                EventUtils.LOGGER.warn("Failed to parse address from event: {}", (Object)eventJson, (Object)e);
            }
        }
        return null;
    }

    @Nullable
    public static String getIp(@NotNull String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : ConnectUtility.removeMarkdown(message).split("\\s+|\\n+")) {
            if (!string.contains(".") || string.contains("/")) continue;
            strings.add(string);
        }
        int size = strings.size();
        if (size == 1) {
            return (String)strings.get(0);
        }
        if (size > 1) {
            for (String string : strings) {
                if (!ConnectUtility.isValidIp(string)) continue;
                return string;
            }
        }
        return null;
    }

    private static boolean isValidIp(@NotNull String ip) {
        HttpRequest request;
        try {
            request = HttpRequest.newBuilder(new URI("https://api.mcstatus.io/v2/status/java/" + ip)).build();
        }
        catch (URISyntaxException e) {
            return false;
        }
        HttpClient client = HttpClient.newHttpClient();
        try {
            String body = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get().body();
            return !body.endsWith(":null}") && !body.endsWith("Not Found") && !body.endsWith("Invalid address value");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static String removeMarkdown(@NotNull String string) {
        return string.replaceAll("<[^>]+>", "").replaceAll("^[=\\-]{2,}\\s*$", "").replaceAll("\\[\\^.+?](: .*?$)?", "").replaceAll("\\s{0,2}\\[.*?]: .*?$", "").replaceAll("!\\[(.*?)][\\[(].*?[])]", "$1").replaceAll("\\[([^]]*?)][\\[(].*?[])]", "$2").replaceAll("(?m)^(\\n)?\\s{0,3}>\\s?", "$1").replaceAll("^\\s{1,2}\\[(.*?)]: (\\S+)( \".*?\")?\\s*$", "").replaceAll("(?m)^(\\n)?\\s*#{1,6}\\s*( (.+))? +#+$|^\\s*#{1,6}\\s*( (.+))?$", "$1$3$4$5").replaceAll("([*]+)(\\S)(.*?\\S)??\\1", "$2$3").replaceAll("(^|\\W)(_+)(\\S)(.*?\\S)??\\2($|\\W)", "$1$3$4$5").replaceAll("(`{3,})(.*?)\\1", "$2").replaceAll("`(.+?)`", "$1").replaceAll("~(.*?)~", "$1");
    }
}

