/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils;

import cc.aabss.eventutils.EventServerManager;
import cc.aabss.eventutils.EventType;
import cc.aabss.eventutils.KeybindManager;
import cc.aabss.eventutils.PrefixMessageFactory;
import cc.aabss.eventutils.UpdateChecker;
import cc.aabss.eventutils.commands.CommandRegister;
import cc.aabss.eventutils.config.EventConfig;
import cc.aabss.eventutils.utility.ConnectUtility;
import cc.aabss.eventutils.websocket.SocketEndpoint;
import cc.aabss.eventutils.websocket.WebSocketClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventUtils
implements ClientModInitializer {
    public static EventUtils MOD;
    @NotNull
    public static final Logger LOGGER;
    @NotNull
    public static final String QUEUE_TEXT = "\n\n Per-server ranks get a higher priority in their respective queues. To receive such a rank, purchase one at\n store.invadedlands.net.\n\nTo leave a queue, use the command: /leavequeue.\n";
    @NotNull
    public static final class_5250 MESSAGE_PREFIX;
    @NotNull
    public static final class_5250 ERROR_MESSAGE_PREFIX;
    @NotNull
    public final EventConfig config = new EventConfig();
    @NotNull
    public final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(3);
    @NotNull
    public final Set<WebSocketClient> webSockets = new HashSet<WebSocketClient>();
    @NotNull
    public final UpdateChecker updateChecker = new UpdateChecker(this);
    public KeybindManager keybindManager;
    @NotNull
    public final EventServerManager eventServerManager = new EventServerManager(this);
    @NotNull
    public final Map<EventType, String> lastIps = new EnumMap<EventType, String>(EventType.class);
    public boolean hidePlayers = false;

    public EventUtils() {
        MOD = this;
    }

    public void onInitializeClient() {
        this.webSockets.add(new WebSocketClient(this, SocketEndpoint.EVENT_POSTED));
        this.webSockets.add(new WebSocketClient(this, SocketEndpoint.FAMOUS_EVENT_POSTED));
        this.webSockets.add(new WebSocketClient(this, SocketEndpoint.EVENT_CANCELLED));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CommandRegister.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> {
            this.webSockets.forEach(socket -> socket.close("Game closed"));
            this.eventServerManager.removeAllEventServers();
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.updateChecker.checkUpdate());
        this.keybindManager = new KeybindManager(this);
        ClientReceiveMessageEvents.ALLOW_GAME.register((text, overlay) -> true);
        ClientReceiveMessageEvents.MODIFY_GAME.register((text, overlay) -> {
            if (this.config.simpleQueueMessage && text.getString().contains(QUEUE_TEXT)) {
                String original = text.getString();
                class_5250 resultText = class_2561.method_43470((String)"");
                for (String line : original.replace(QUEUE_TEXT, "").replaceFirst("\n", "").split("\n")) {
                    String[] parts = line.split(": ");
                    if (parts.length <= 1) {
                        resultText.method_10852((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1065));
                        continue;
                    }
                    if (!resultText.method_10855().isEmpty()) {
                        resultText.method_27693("\n");
                    }
                    String[] valueParts = parts[1].split("/");
                    resultText.method_10852((class_2561)class_2561.method_43470((String)parts[0]).method_27692(class_124.field_1065).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)valueParts[0]).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)valueParts[1]).method_27692(class_124.field_1054)));
                }
                return resultText;
            }
            return text;
        });
    }

    @Nullable
    public String getIpAndConnect(@NotNull EventType eventType, @NotNull JsonObject message) {
        if (eventType == EventType.SKEPPY || eventType == EventType.POTENTIAL_FAMOUS || eventType == EventType.SIGHTING || eventType == EventType.FAMOUS) {
            String ip = ConnectUtility.getIp(message.get("message").getAsString());
            if (this.config.autoTp) {
                ConnectUtility.connect(ip == null ? this.config.defaultFamousIp : ip);
            }
            return ip;
        }
        String ip = null;
        if (eventType == EventType.HOUSING) {
            ip = "hypixel.net";
        } else {
            String extracted = ConnectUtility.extractIp(message);
            if (extracted != null && !extracted.isEmpty()) {
                ip = extracted;
            }
        }
        if (this.config.autoTp && ip != null) {
            ConnectUtility.connect(ip);
        }
        return ip;
    }

    public static boolean isNPC(@NotNull String name, boolean bypass) {
        return !(EventUtils.MOD.config.hideNPCs && !bypass || !name.contains("[") && !name.contains("]") && !name.contains(" ") && !name.contains("-") && !name.equals("\u00a7z"));
    }

    public static boolean isNPC(@NotNull String name) {
        return EventUtils.isNPC(name, false);
    }

    @Contract(pure=true)
    public static int max(int ... values) {
        int max = Integer.MIN_VALUE;
        for (int value : values) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    @NotNull
    public static String translate(@NotNull String key) {
        return class_2477.method_10517().method_48307(key);
    }

    public void simulateTestEvent() {
        long currentTime = System.currentTimeMillis();
        long eventTime = currentTime + 30000L;
        JsonObject testEvent = new JsonObject();
        testEvent.addProperty("id", "test-event-" + currentTime);
        testEvent.addProperty("title", "Test Event");
        testEvent.addProperty("description", "This is a simulated test event for testing the server list feature. Server: mc.hypixel.net");
        testEvent.addProperty("time", (Number)eventTime);
        testEvent.addProperty("ip", "invadedlands.net");
        testEvent.addProperty("prize", "$1000");
        JsonArray rolesArray = new JsonArray();
        rolesArray.add("MONEY");
        testEvent.add("rolesNamed", (JsonElement)rolesArray);
        LOGGER.info("Simulating test event: {}", (Object)testEvent.toString());
        SocketEndpoint.EVENT_POSTED.handler.accept(this, testEvent.toString());
        SocketEndpoint.LAST_EVENT = testEvent;
    }

    static {
        LOGGER = LogManager.getLogger(EventUtils.class, (MessageFactory)new PrefixMessageFactory());
        MESSAGE_PREFIX = class_2561.method_43470((String)"EventUtils").method_27692(class_124.field_1067).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)16099906))).method_10852((class_2561)class_2561.method_43470((String)"\u00a7r \u00bb").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(false)).method_27703(class_5251.method_27717((int)11893807))));
        ERROR_MESSAGE_PREFIX = class_2561.method_43470((String)"EventUtils").method_27692(class_124.field_1067).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"\u00a7r\u00a74 \u00bb").method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(false))));
    }
}

