/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.config;

import cc.aabss.eventutils.EventType;
import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.Versions;
import cc.aabss.eventutils.config.FileLoader;
import cc.aabss.eventutils.config.NotificationSound;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonObject;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.impl.util.version.SemanticVersionImpl;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;

public class EventConfig
extends FileLoader {
    public boolean discordRpc;
    public boolean autoTp;
    public boolean simpleQueueMessage;
    public boolean updateChecker;
    public boolean confirmWindowClose;
    public boolean confirmDisconnect;
    public boolean hideNPCs;
    public int hidePlayersRadius;
    @NotNull
    public String defaultFamousIp;
    @NotNull
    public List<class_1299<?>> hiddenEntityTypes;
    @NotNull
    public List<String> whitelistedPlayers;
    public boolean useTestingApi;
    @NotNull
    public final List<EventType> eventTypes;
    @NotNull
    public final Map<EventType, NotificationSound> notificationSounds;

    public EventConfig() {
        super(new File(FabricLoader.getInstance().getConfigDir().toFile(), "eventutils.json"));
        boolean created = false;
        if (!this.file.exists()) {
            this.json = new JsonObject();
            this.json.addProperty("version", Versions.EU_VERSION);
            created = true;
        } else {
            this.load();
            this.update();
        }
        this.discordRpc = this.get("discord_rpc", true);
        this.autoTp = this.get("auto_tp", false);
        this.simpleQueueMessage = this.get("simple_queue_message", false);
        this.updateChecker = this.get("update_checker", true);
        this.confirmWindowClose = this.get("confirm_window_close", true);
        this.confirmDisconnect = this.get("confirm_disconnect", true);
        this.defaultFamousIp = this.get("default_famous_ip", "play.invadedlands.net");
        this.hidePlayersRadius = this.get("hide_players_radius", 0);
        this.hideNPCs = this.get("hide_npcs", true);
        this.hiddenEntityTypes = this.get("hidden_entity_types", Defaults.hiddenEntityTypes(), new TypeToken<List<class_1299<?>>>(){}.getType());
        this.whitelistedPlayers = this.get("whitelisted_players", Defaults.whitelistedPlayers(), new TypeToken<List<String>>(){}.getType());
        this.useTestingApi = this.get("use_testing_api", false);
        this.eventTypes = this.get("notifications", Defaults.eventTypes(), new TypeToken<List<EventType>>(){}.getType());
        this.notificationSounds = this.get("notification_sounds", Defaults.notificationSounds(), new TypeToken<Map<EventType, NotificationSound>>(){}.getType());
        if (created) {
            this.save();
        }
    }

    private void update() {
        Integer radius;
        String oldVersionString = this.get("version", "1.4.0");
        SemanticVersion oldVersion = Versions.getSemantic(oldVersionString);
        if (oldVersion == null) {
            EventUtils.LOGGER.error("Failed to parse config version: {}", (Object)oldVersionString);
            return;
        }
        if (oldVersion.compareTo((Object)new SemanticVersionImpl(new int[]{2, 0, 0}, null, null)) < 0) {
            this.update("discord-rpc", "discord_rpc", (Type)((Object)Boolean.class));
            this.update("auto-tp", "auto_tp", (Type)((Object)Boolean.class));
            this.update("simple-queue-msg", "simple_queue_message", (Type)((Object)Boolean.class));
            this.update("update-checker", "update_checker", (Type)((Object)Boolean.class));
            this.update("confirm-window-close", "confirm_window_close", (Type)((Object)Boolean.class));
            this.update("confirm-disconnect", "confirm_disconnect", (Type)((Object)Boolean.class));
            this.update("default-famous-ip", "default_famous_ip", (Type)((Object)String.class));
            this.set("whitelisted_players", this.get("whitelisted-players", Defaults.WHITELISTED_PLAYERS, new TypeToken<List<String>>(){}.getType()).stream().map(String::toLowerCase).toList());
            this.remove("whitelisted-players");
            HashSet<EventType> types = new HashSet<EventType>();
            for (EventType type : EventType.values()) {
                String key = type.name().toLowerCase().replace("_", "-") + "-event";
                if (this.get(key, true).booleanValue()) {
                    types.add(type);
                }
                this.remove(key);
            }
            this.set("notifications", types);
        }
        if (oldVersion.compareTo((Object)new SemanticVersionImpl(new int[]{2, 0, 7}, null, null)) <= 0 && (radius = (Integer)this.get("hide_players_radius", TypeToken.of(Integer.class).getType())) != null && radius == 1) {
            this.set("hide_players_radius", 0);
        }
        this.set("version", Versions.EU_VERSION);
        this.save();
    }

    private void update(@NotNull String oldKey, @NotNull String newKey, @NotNull Type type) {
        this.set(newKey, this.get(oldKey, type));
        this.remove(oldKey);
    }

    @NotNull
    public String getWebsocketHost() {
        return this.useTestingApi ? "ws://localhost:9090" : "wss://eventalerts.gg";
    }

    @NotNull
    public NotificationSound getNotificationSound(@NotNull EventType type) {
        return this.notificationSounds.getOrDefault((Object)type, NotificationSound.ALERT);
    }

    public static class Defaults {
        public static final boolean DISCORD_RPC = true;
        public static final boolean AUTO_TP = false;
        public static final boolean SIMPLE_QUEUE_MESSAGE = false;
        public static final boolean UPDATE_CHECKER = true;
        public static final boolean CONFIRM_WINDOW_CLOSE = true;
        public static final boolean CONFIRM_DISCONNECT = true;
        public static final boolean HIDE_NPCS = true;
        public static final int HIDE_PLAYERS_RADIUS = 0;
        @NotNull
        public static final String DEFAULT_FAMOUS_IP = "play.invadedlands.net";
        @NotNull
        private static final List<class_1299<?>> HIDDEN_ENTITY_TYPES = List.of(class_1299.field_28401);
        @NotNull
        private static final List<String> HIDDEN_ENTITY_TYPES_STRING = List.of("minecraft:glow_item_frame");
        @NotNull
        private static final List<String> WHITELISTED_PLAYERS = List.of("skeppy", "badboyhalo");
        public static final boolean USE_TESTING_API = false;
        @NotNull
        private static final List<EventType> EVENT_TYPES = List.of(EventType.values());
        @NotNull
        private static final Map<EventType, NotificationSound> NOTIFICATION_SOUNDS = Arrays.stream(EventType.values()).collect(HashMap::new, (map, type) -> map.put(type, NotificationSound.ALERT), HashMap::putAll);

        @NotNull
        public static List<class_1299<?>> hiddenEntityTypes() {
            return new ArrayList(HIDDEN_ENTITY_TYPES);
        }

        @NotNull
        public static List<String> hiddenEntityTypesString() {
            return new ArrayList<String>(HIDDEN_ENTITY_TYPES_STRING);
        }

        @NotNull
        public static List<String> whitelistedPlayers() {
            return new ArrayList<String>(WHITELISTED_PLAYERS);
        }

        @NotNull
        public static List<EventType> eventTypes() {
            return new ArrayList<EventType>(EVENT_TYPES);
        }

        @NotNull
        public static Map<EventType, NotificationSound> notificationSounds() {
            return new HashMap<EventType, NotificationSound>(NOTIFICATION_SOUNDS);
        }
    }
}

