/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.config;

import cc.aabss.eventutils.EventType;
import cc.aabss.eventutils.config.NotificationSound;
import cc.aabss.eventutils.config.adapters.EntityTypeAdapter;
import cc.aabss.eventutils.config.adapters.EntityTypeListAdapter;
import cc.aabss.eventutils.config.adapters.EventTypeSetAdapter;
import cc.aabss.eventutils.config.adapters.MapEventTypeNotificationSoundAdapter;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileLoader {
    @NotNull
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_1299.class, (Object)new EntityTypeAdapter()).registerTypeAdapter(new TypeToken<List<class_1299<?>>>(){}.getType(), (Object)new EntityTypeListAdapter()).registerTypeAdapter(new TypeToken<Set<EventType>>(){}.getType(), (Object)new EventTypeSetAdapter()).registerTypeAdapter(new TypeToken<Map<EventType, NotificationSound>>(){}.getType(), (Object)new MapEventTypeNotificationSoundAdapter()).create();
    @NotNull
    protected final File file;
    @NotNull
    protected JsonObject json = new JsonObject();

    public FileLoader(@NotNull File file) {
        this.file = file;
    }

    protected void load(@NotNull File newFile) {
        try (FileReader fileReader = new FileReader(newFile);){
            this.json = JsonParser.parseReader((Reader)fileReader).getAsJsonObject();
        }
        catch (JsonParseException | IOException e) {
            this.json = new JsonObject();
            this.save();
        }
    }

    protected void load() {
        this.load(this.file);
    }

    @Nullable
    public JsonElement get(@NotNull String key) {
        return this.json.get(key);
    }

    @NotNull
    public <T> T get(@NotNull String key, @NotNull T defaultValue) {
        return this.get(key, defaultValue, TypeToken.of(defaultValue.getClass()).getType());
    }

    @NotNull
    public <T> T get(@NotNull String key, @NotNull T defaultValue, @NotNull Type type) {
        T value = this.get(key, type);
        return value == null ? defaultValue : value;
    }

    @Nullable
    public <T> T get(@NotNull String key, @NotNull Type type) {
        JsonElement element = this.json.get(key);
        if (element == null) {
            this.remove(key);
            return null;
        }
        try {
            return (T)GSON.fromJson(element, type);
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            this.remove(key);
            throw new RuntimeException(e);
        }
    }

    public <T> void set(@NotNull String key, @Nullable T value) {
        if (value == null) {
            this.remove(key);
            return;
        }
        this.json.add(key, GSON.toJsonTree(value));
    }

    public <T> void setSave(@NotNull String key, @Nullable T value) {
        this.set(key, value);
        this.save();
    }

    public void remove(@NotNull String key) {
        this.json.remove(key);
    }

    public void save() {
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(GSON.toJson((JsonElement)this.json));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save config", e);
        }
    }
}

