/*
 * Decompiled with CFR 0.152.
 */
package cc.aabss.eventutils.websocket;

import cc.aabss.eventutils.EventUtils;
import cc.aabss.eventutils.Versions;
import cc.aabss.eventutils.websocket.SocketEndpoint;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketClient
implements WebSocket.Listener {
    @NotNull
    private static final ByteBuffer PING = ByteBuffer.wrap(new byte[]{0});
    @NotNull
    private final EventUtils mod;
    @NotNull
    private final SocketEndpoint endpoint;
    @Nullable
    private WebSocket webSocket;
    @Nullable
    private HttpClient httpClient;
    @Nullable
    private ScheduledFuture<?> keepAlive;
    private boolean isRetrying = false;

    public WebSocketClient(@NotNull EventUtils mod, @NotNull SocketEndpoint endpoint) {
        this.mod = mod;
        this.endpoint = endpoint;
        this.connect();
    }

    public void connect() {
        EventUtils.LOGGER.info("Attempting to establish WebSocket connection for {}", (Object)this.endpoint);
        this.httpClient = HttpClient.newHttpClient();
        this.httpClient.newWebSocketBuilder().header("User-Agent", "EventUtils/" + Versions.EU_VERSION + " (MC/" + Versions.MC_VERSION + ")").buildAsync(URI.create(this.mod.config.getWebsocketHost() + "/api/v1/socket/" + this.endpoint.name().toLowerCase()), this).whenComplete((newSocket, throwable) -> {
            this.isRetrying = false;
            if (throwable != null) {
                EventUtils.LOGGER.error("Failed to establish WebSocket connection!", throwable);
                this.retryConnection("Error thrown when establishing connection");
                return;
            }
            this.webSocket = newSocket;
            this.webSocket.request(1L);
            this.keepAlive = this.mod.scheduler.scheduleAtFixedRate(() -> {
                if (newSocket.isInputClosed()) {
                    this.retryConnection("Keep-alive detected closed input");
                    return;
                }
                newSocket.sendPing(PING);
            }, 0L, 30L, TimeUnit.SECONDS);
            EventUtils.LOGGER.info("{} socket connection established", (Object)this.endpoint);
        });
    }

    public void retryConnection(@NotNull String reason) {
        if (this.isRetrying) {
            return;
        }
        this.isRetrying = true;
        this.close("Retrying connection");
        this.mod.scheduler.schedule(() -> {
            EventUtils.LOGGER.warn("Retrying websocket connection for {} with reason \"{}\"", (Object)this.endpoint, (Object)reason);
            this.connect();
        }, 10L, TimeUnit.SECONDS);
    }

    public void close(@NotNull String reason) {
        if (this.webSocket != null) {
            this.webSocket.sendClose(1000, reason);
        }
        this.closeTasks();
    }

    private void closeTasks() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.keepAlive != null) {
            this.keepAlive.cancel(true);
        }
    }

    @Override
    public CompletionStage<?> onText(@NotNull WebSocket webSocket, @NotNull CharSequence data, boolean last) {
        String message = data.toString();
        webSocket.request(1L);
        EventUtils.LOGGER.info("Received {} message: {}", (Object)this.endpoint.name(), (Object)message);
        try {
            this.endpoint.handler.accept(this.mod, message);
        }
        catch (Exception e) {
            EventUtils.LOGGER.error("Failed to handle message: {}", (Object)message, (Object)e);
        }
        return null;
    }

    @Override
    public CompletionStage<?> onClose(@NotNull WebSocket webSocket, int statusCode, @NotNull String reason) {
        this.closeTasks();
        if (statusCode == 1006) {
            this.retryConnection("Experienced abnormal closure");
            return null;
        }
        EventUtils.LOGGER.info("{} socket closed with status code {} and reason \"{}\"", (Object)this.endpoint.name(), (Object)statusCode, (Object)reason);
        return null;
    }

    @Override
    public void onError(@NotNull WebSocket webSocket, @NotNull Throwable error) {
        this.retryConnection("Experienced an error! See below for details");
        error.printStackTrace();
    }
}

