/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.mixin.transpiler;

import com.thejebforge.trickster_lisp.transpiler.SpellConverter;
import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.fragment.FragmentToAST;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import java.util.Optional;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={SpellPart.class})
public class MixinSpellPart
implements FragmentToAST {
    @Unique
    private SExpression spellPartToExpression(SpellPart part, boolean preserveSpellParts) {
        Fragment fragment = part.getGlyph();
        if (fragment instanceof PatternGlyph) {
            Identifier idString;
            PatternGlyph pattern = (PatternGlyph)fragment;
            if (pattern.pattern().isEmpty()) {
                CallBuilder builder = CallBuilder.builder();
                part.getSubParts().forEach(subpart -> {
                    Optional<SExpression> potentialAST = ((FragmentToAST)subpart).trickster_lisp$convert(preserveSpellParts);
                    if (potentialAST.isPresent()) {
                        builder.add(potentialAST.get());
                    } else {
                        builder.add(new Identifier("unknown"));
                    }
                });
                return builder.build();
            }
            Trick trick = Tricks.lookup((Pattern)pattern.pattern());
            class_2960 id = Tricks.REGISTRY.method_10221((Object)trick);
            if (id != null && id.method_12832().startsWith("load_argument_")) {
                int number = Integer.parseInt(id.method_12832().substring("load_argument_".length()));
                return CallBuilder.builder("arg").addNumber(number).build();
            }
            if (id == null) {
                return CallBuilder.builder("pattern").addNumber(pattern.pattern().toInt()).build();
            }
            SExpression sExpression = id.method_12836().equals("trickster") ? (SpellConverter.OPERATOR_MAPPING.containsKey((Object)id.method_12832()) ? new Operator((String)SpellConverter.OPERATOR_MAPPING.get((Object)id.method_12832())) : new Identifier(id.method_12832())) : (idString = new Identifier(id.toString()));
            if (part.subParts.isEmpty()) {
                return idString;
            }
            CallBuilder builder = CallBuilder.builder(idString);
            part.getSubParts().forEach(subpart -> builder.add(this.spellPartToExpression((SpellPart)subpart, preserveSpellParts)));
            return builder.build();
        }
        SExpression subject = SpellConverter.fragmentToExpression(part.glyph);
        if (part.getSubParts().isEmpty() && !preserveSpellParts) {
            if (subject instanceof Call) {
                Identifier id;
                Call call = (Call)subject;
                SExpression sExpression = call.getSubject();
                if (sExpression instanceof Identifier && SpellConverter.FRAGMENT_IDS.contains((id = (Identifier)sExpression).getName())) {
                    return subject;
                }
            } else {
                Fragment fragment2 = part.glyph;
                if (fragment2 instanceof SpellPart) {
                    SpellPart inner = (SpellPart)fragment2;
                    if (!(inner.glyph instanceof SpellPart)) {
                        return CallBuilder.builder(CallBuilder.builder(subject).build()).build();
                    }
                }
                return subject;
            }
        }
        CallBuilder builder = CallBuilder.builder(subject);
        part.getSubParts().forEach(subpart -> builder.add(this.spellPartToExpression((SpellPart)subpart, preserveSpellParts)));
        return builder.build();
    }

    @Override
    public Optional<SExpression> trickster_lisp$convert(boolean preserveSpellParts) {
        return Optional.ofNullable(this.spellPartToExpression((SpellPart)this, preserveSpellParts));
    }
}

