/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.screen;

import com.thejebforge.trickster_lisp.item.ModItems;
import com.thejebforge.trickster_lisp.item.component.MacroDefinitionComponent;
import com.thejebforge.trickster_lisp.item.component.ModComponents;
import com.thejebforge.trickster_lisp.item.component.RawCodeComponent;
import com.thejebforge.trickster_lisp.screen.ModScreenHandlers;
import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.SpellConverter;
import com.thejebforge.trickster_lisp.transpiler.ast.Macro;
import com.thejebforge.trickster_lisp.transpiler.ast.Root;
import com.thejebforge.trickster_lisp.transpiler.util.CallUtils;
import dev.enjarai.trickster.item.component.FragmentComponent;
import dev.enjarai.trickster.spell.Fragment;
import io.vavr.collection.HashSet;
import io.wispforest.owo.client.screens.SyncedProperty;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public class TranspilerScreenHandler
extends class_1703 {
    public final class_1799 currentStack;
    public class_1799 otherHandStack;
    public final SyncedProperty<String> validationText = this.createProperty(String.class, "");
    public final SyncedProperty<String> initialRawCode = this.createProperty(String.class, "");
    public final SyncedProperty<HashSet<Macro>> macros = this.createProperty(null, MacroDefinitionComponent.MACRO_SET_ENDEC, HashSet.empty());
    public Consumer<String> replaceCodeCallback;

    public TranspilerScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, playerInventory.field_7546, null, null, null, (HashSet<Macro>)HashSet.empty());
    }

    public TranspilerScreenHandler(int syncId, class_1661 playerInventory, class_1657 player, class_1268 hand, class_1799 currentStack, class_1799 otherHandStack, HashSet<Macro> externalMacros) {
        super(ModScreenHandlers.TRANSPILER, syncId);
        RawCodeComponent code;
        this.currentStack = currentStack;
        this.otherHandStack = otherHandStack;
        this.macros.set(externalMacros);
        if (currentStack != null && (code = (RawCodeComponent)currentStack.method_57824(ModComponents.RAW_CODE_COMPONENT)) != null) {
            this.initialRawCode.set((Object)code.content());
        }
        this.addServerboundMessage(LoadCode.class, msg -> {
            if (otherHandStack != null) {
                RawCodeComponent code = (RawCodeComponent)otherHandStack.method_57824(ModComponents.RAW_CODE_COMPONENT);
                if (code != null) {
                    this.sendMessage(new ReplaceCode(code.content()));
                    this.validationText.set((Object)"Code loaded successfully");
                    return;
                }
                MacroDefinitionComponent macros = (MacroDefinitionComponent)otherHandStack.method_57824(ModComponents.MACRO_DEFINITION_COMPONENT);
                FragmentComponent spell = (FragmentComponent)otherHandStack.method_57824(dev.enjarai.trickster.item.component.ModComponents.FRAGMENT);
                if (spell != null && !spell.closed()) {
                    this.sendMessage(new ReplaceCode(SpellConverter.spellToAST(spell.value(), macros != null ? macros.macros() : Collections.emptyList(), ((HashSet)this.macros.get()).toJavaList()).toCode()));
                    this.validationText.set((Object)"Spell loaded successfully");
                    return;
                }
            }
            this.validationText.set((Object)"Couldn't load spell from offhand");
        });
        this.addServerboundMessage(ValidateCode.class, msg -> {
            this.validationText.set((Object)"");
            this.saveCode(msg.code);
            try {
                Root ast = LispUtils.parse(msg.code);
                this.validationText.set((Object)"SUCCESS");
                this.sendMessage(new ReplaceCode(ast.toCode()));
            }
            catch (LispUtils.ParseError e) {
                this.validationText.set((Object)e.getMessage());
            }
        });
        this.addServerboundMessage(SaveCode.class, msg -> this.saveCode(msg.code));
        this.addServerboundMessage(StoreCode.class, msg -> {
            this.validationText.set((Object)"");
            this.saveCode(msg.code);
            if (otherHandStack == null || otherHandStack.method_7960()) {
                this.validationText.set((Object)"No item in other hand is found");
                return;
            }
            if (otherHandStack.method_31574((class_1792)ModItems.PAPER_AND_PENCIL)) {
                otherHandStack.method_57379(ModComponents.RAW_CODE_COMPONENT, (Object)new RawCodeComponent(msg.code));
                this.validationText.set((Object)"Printed code to paper");
                return;
            }
            try {
                Root ast = LispUtils.parse(msg.code);
                Fragment spellPart = SpellConverter.astToFinalFragment(ast, ((HashSet)this.macros.get()).toJavaList());
                FragmentComponent.setValue((class_1799)otherHandStack, (Fragment)spellPart, Optional.empty(), (boolean)false);
                List<Macro> macros = ast.retrieveMacros();
                if (!macros.isEmpty()) {
                    otherHandStack.method_57379(ModComponents.MACRO_DEFINITION_COMPONENT, (Object)new MacroDefinitionComponent(macros));
                } else {
                    otherHandStack.method_57381(ModComponents.MACRO_DEFINITION_COMPONENT);
                }
                this.validationText.set((Object)"SUCCESS");
            }
            catch (LispUtils.ParseError | CallUtils.ConversionError e) {
                this.validationText.set((Object)e.getMessage());
            }
        });
        this.addClientboundMessage(ReplaceCode.class, msg -> {
            if (this.replaceCodeCallback != null) {
                this.replaceCodeCallback.accept(msg.code);
            }
        });
    }

    private void saveCode(String code) {
        if (this.currentStack != null) {
            this.currentStack.method_57379(ModComponents.RAW_CODE_COMPONENT, (Object)new RawCodeComponent(code));
        }
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public record LoadCode() {
    }

    public record ValidateCode(String code) {
    }

    public record SaveCode(String code) {
    }

    public record StoreCode(String code) {
    }

    public record ReplaceCode(String code) {
    }
}

