/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.screen.transpiler;

import com.thejebforge.trickster_lisp.screen.transpiler.TextRendererWithStyle;
import io.wispforest.owo.Owo;
import io.wispforest.owo.mixin.ui.access.EditBoxAccessor;
import io.wispforest.owo.mixin.ui.access.EditBoxWidgetAccessor;
import io.wispforest.owo.ui.component.VanillaWidgetComponent;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Size;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.parsing.UIModel;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.util.EventSource;
import io.wispforest.owo.util.EventStream;
import io.wispforest.owo.util.Observable;
import java.util.Map;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7529;
import net.minecraft.class_7530;
import net.minecraft.class_7533;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;

@Environment(value=EnvType.CLIENT)
public class CodeEditorComponent
extends class_7529 {
    public static final int INDENTATION = 4;
    protected final Observable<String> textValue = Observable.of((Object)"");
    protected final EventStream<OnChanged> changedEvents = OnChanged.newStream();
    protected final class_7530 editBox;
    protected final Observable<Boolean> displayCharCount = Observable.of((Object)false);
    protected final Observable<Integer> maxLines = Observable.of((Object)-1);
    private Runnable onKeyPress = this.onKeyPress;

    protected CodeEditorComponent(Sizing horizontalSizing, Sizing verticalSizing) {
        super((class_327)new TextRendererWithStyle(class_310.method_1551().field_1772), 0, 0, 0, 0, (class_2561)class_2561.method_43473(), (class_2561)class_2561.method_43473());
        this.editBox = ((EditBoxWidgetAccessor)this).owo$getEditBox();
        this.sizing(horizontalSizing, verticalSizing);
        this.textValue.observe(((OnChanged)this.changedEvents.sink())::onChanged);
        Observable.observeAll(() -> ((VanillaWidgetComponent)this.widgetWrapper()).notifyParentIfMounted(), (Observable[])new Observable[]{this.displayCharCount, this.maxLines});
        super.method_44401(s -> {
            this.textValue.set(s);
            if ((Integer)this.maxLines.get() < 0) {
                return;
            }
            this.widgetWrapper().notifyParentIfMounted();
        });
    }

    @Deprecated(forRemoval=true)
    public void method_44401(Consumer<String> changeListener) {
        Owo.debugWarn((Logger)Owo.LOGGER, (String)"setChangeListener stub on TextAreaComponent invoked");
    }

    public void update(float delta, int mouseX, int mouseY) {
        super.update(delta, mouseX, mouseY);
        this.cursorStyle(this.method_44392() && mouseX >= this.method_46426() + this.field_22758 - 9 ? CursorStyle.NONE : CursorStyle.TEXT);
    }

    protected void method_44384(class_332 context) {
        --this.field_22759;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(-9.0f, 1.0f, 0.0f);
        int previousMaxLength = this.editBox.method_44409();
        this.editBox.method_44411(Integer.MAX_VALUE);
        super.method_44384(context);
        this.editBox.method_44411(previousMaxLength);
        matrices.method_22909();
        ++this.field_22759;
        if (((Boolean)this.displayCharCount.get()).booleanValue()) {
            class_5250 text = this.editBox.method_44418() ? class_2561.method_43469((String)"gui.multiLineEditBox.character_limit", (Object[])new Object[]{this.editBox.method_44421().length(), this.editBox.method_44409()}) : class_2561.method_43470((String)String.valueOf(this.editBox.method_44421().length()));
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_27535(textRenderer, (class_2561)text, this.method_46426() + this.field_22758 - textRenderer.method_27525((class_5348)text), this.method_46427() + this.field_22759 + 3, 0xA0A0A0);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.field_22758 -= 9;
        boolean result = super.method_25402(mouseX, mouseY, button);
        this.field_22758 += 9;
        return result;
    }

    public Runnable getOnKeyPress() {
        return this.onKeyPress;
    }

    public void setOnKeyPress(Runnable onKeyPress) {
        this.onKeyPress = onKeyPress;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.onKeyPress != null) {
            this.onKeyPress.run();
        }
        boolean result = super.method_25404(keyCode, scanCode, modifiers);
        if (keyCode == 258) {
            this.editBox.method_44420(" ".repeat(4));
            return true;
        }
        if (keyCode == 257) {
            this.indentNewLine();
            return true;
        }
        return result;
    }

    private String substring(class_7530.class_7531 sub) {
        return this.editBox.method_44421().substring(sub.comp_862(), sub.comp_863());
    }

    private int lastIndexOfHighestFound(String text, String chars) {
        int result = -1;
        for (char c : chars.toCharArray()) {
            int index = text.lastIndexOf(c);
            if (index == -1) continue;
            result = result == -1 ? index : Math.max(result, index);
        }
        return result;
    }

    private int indexOfLowestFound(String text, String chars, int fromIndex) {
        int result = -1;
        for (char c : chars.toCharArray()) {
            int index = text.indexOf(c, fromIndex);
            if (index == -1) continue;
            result = result == -1 ? index : Math.min(result, index);
        }
        return result;
    }

    private int countOpenLists(String text) {
        int open = 0;
        int cursor = -1;
        while (cursor < text.length()) {
            int openIndex = this.indexOfLowestFound(text, "([", cursor + 1);
            int closedIndex = this.indexOfLowestFound(text, "])", cursor + 1);
            if (openIndex == -1 && closedIndex == -1) break;
            if (openIndex == -1) {
                --open;
                cursor = closedIndex;
                continue;
            }
            if (closedIndex == -1) {
                ++open;
                cursor = openIndex;
                continue;
            }
            if (openIndex < closedIndex) {
                ++open;
                cursor = openIndex;
                continue;
            }
            --open;
            cursor = closedIndex;
        }
        return open;
    }

    private void indentNewLine() {
        int indentationToAdd = 0;
        String text = this.editBox.method_44421();
        int cursor = this.editBox.method_44424();
        for (int lineIndex = this.editBox.method_44432(); lineIndex >= 0; --lineIndex) {
            String searchSpace;
            int start;
            class_7530.class_7531 location = this.editBox.method_44422(lineIndex);
            String line = this.substring(location);
            int indent = this.lastIndexOfHighestFound(line, "([");
            if (indent == -1 || (start = location.comp_862() + indent) >= cursor || this.countOpenLists(searchSpace = text.substring(start, cursor)) <= 0) continue;
            indentationToAdd = indent + 4;
            break;
        }
        this.editBox.method_44420(" ".repeat(indentationToAdd));
    }

    public void inflate(Size space) {
        super.inflate(space);
        int cursor = this.editBox.method_44424();
        int selection = ((EditBoxAccessor)this.editBox).owo$getSelectionEnd();
        ((EditBoxAccessor)this.editBox).owo$setWidth(this.width() - this.method_44385() - 9);
        this.editBox.method_44414(this.method_44405());
        super.inflate(space);
        this.editBox.method_44414(this.method_44405());
        this.editBox.method_44412(class_7533.field_39535, cursor);
        ((EditBoxAccessor)this.editBox).owo$setSelectionEnd(selection);
    }

    public EventSource<OnChanged> onChanged() {
        return this.changedEvents.source();
    }

    public CodeEditorComponent maxLines(int maxLines) {
        this.maxLines.set((Object)maxLines);
        return this;
    }

    public int maxLines() {
        return (Integer)this.maxLines.get();
    }

    public CodeEditorComponent displayCharCount(boolean displayCharCount) {
        this.displayCharCount.set((Object)displayCharCount);
        return this;
    }

    public boolean displayCharCount() {
        return (Boolean)this.displayCharCount.get();
    }

    public CodeEditorComponent text(String text) {
        this.method_44400(text);
        return this;
    }

    public int heightOffset() {
        return (Boolean)this.displayCharCount.get() != false ? -12 : 0;
    }

    public void parseProperties(UIModel model, Element element, Map<String, Element> children) {
        super.parseProperties(model, element, children);
        UIParsing.apply(children, (String)"display-char-count", UIParsing::parseBool, this::displayCharCount);
        UIParsing.apply(children, (String)"max-length", UIParsing::parseUnsignedInt, arg_0 -> ((CodeEditorComponent)this).method_44402(arg_0));
        UIParsing.apply(children, (String)"max-lines", UIParsing::parseUnsignedInt, this::maxLines);
        UIParsing.apply(children, (String)"text", $ -> $.getTextContent().strip(), this::text);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface OnChanged {
        public void onChanged(String var1);

        public static EventStream<OnChanged> newStream() {
            return new EventStream(subscribers -> value -> {
                for (OnChanged subscriber : subscribers) {
                    subscriber.onChanged(value);
                }
            });
        }
    }
}

