/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler;

import com.thejebforge.trickster_lisp.parser.lispLexer;
import com.thejebforge.trickster_lisp.parser.lispParser;
import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Empty;
import com.thejebforge.trickster_lisp.transpiler.ast.ExpressionList;
import com.thejebforge.trickster_lisp.transpiler.ast.Greedy;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Macro;
import com.thejebforge.trickster_lisp.transpiler.ast.MacroCall;
import com.thejebforge.trickster_lisp.transpiler.ast.MapExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.PreProcessor;
import com.thejebforge.trickster_lisp.transpiler.ast.Root;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.StringExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.Void;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ConsoleErrorListener;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ParseTree;

public abstract class LispUtils {
    public static final int DEFAULT_TAB_SIZE = 4;

    public static String addIndent(int indent, boolean inline) {
        return inline ? "" : " ".repeat(indent);
    }

    public static String toCallCode(int indent, int tabSize, boolean inline, String subjectCode, List<SExpression> arguments) {
        List<String> codeArguments = arguments.stream().map(expression -> expression.toCode(indent + tabSize, tabSize, true)).toList();
        int argumentsLength = codeArguments.stream().map(String::length).reduce(0, (result, len) -> result + len + 1);
        if (argumentsLength > 40) {
            return LispUtils.addIndent(indent, inline) + "(" + subjectCode + "\n" + codeArguments.stream().map(arg -> LispUtils.addIndent(indent + tabSize, false) + arg).collect(Collectors.joining("\n")) + "\n" + " ".repeat(indent) + ")";
        }
        return LispUtils.addIndent(indent, inline) + "(" + subjectCode + String.valueOf(codeArguments.isEmpty() ? "" : Character.valueOf(' ')) + String.join((CharSequence)" ", codeArguments) + ")";
    }

    public static Root parse(String code) {
        lispLexer lexer = new lispLexer((CharStream)CharStreams.fromString((String)code));
        lexer.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        lispParser parser = new lispParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListener((ANTLRErrorListener)ConsoleErrorListener.INSTANCE);
        ErrorListerer listener = new ErrorListerer();
        parser.addErrorListener(listener);
        Root root = LispUtils.visitRoot(parser.root());
        listener.throwExceptionIfNeeded();
        return root;
    }

    public static Root visitRoot(lispParser.RootContext rootContext) {
        return new Root(rootContext.preprocessor().stream().map(LispUtils::visitPreProcessor).collect(Collectors.toCollection(ArrayList::new)), rootContext.sExpression().stream().map(c -> LispUtils.visitSExpression(c, false)).collect(Collectors.toCollection(ArrayList::new)));
    }

    public static PreProcessor visitPreProcessor(lispParser.PreprocessorContext preprocessorContext) {
        if (preprocessorContext instanceof lispParser.MacroContext) {
            lispParser.MacroContext macroContext = (lispParser.MacroContext)preprocessorContext;
            return new Macro(macroContext.name.getText(), macroContext.args.stream().map(Token::getText).toList(), macroContext.GREEDY() != null, LispUtils.visitSExpression(macroContext.substitute, true));
        }
        return null;
    }

    public static SExpression visitSExpression(lispParser.SExpressionContext expressionContext, boolean inMacro) {
        if (expressionContext.GREEDY() != null && !inMacro) {
            LispUtils.throwAtToken(expressionContext, "Greedy argument operator is not allowed outside of macro definitions");
        }
        if (expressionContext.IDENTIFIER() != null) {
            return new Identifier(expressionContext.IDENTIFIER().getText());
        }
        if (expressionContext.OPERATOR() != null) {
            return new Operator(expressionContext.OPERATOR().getText());
        }
        if (expressionContext.INTEGER() != null) {
            return new IntegerValue(Integer.parseInt(expressionContext.INTEGER().getText()));
        }
        if (expressionContext.FLOAT() != null) {
            return new DoubleValue(Double.parseDouble(expressionContext.FLOAT().getText()));
        }
        if (expressionContext.STRING() != null) {
            String value = expressionContext.STRING().getText();
            value = value.substring(1, value.length() - 1);
            return new StringExpression(value);
        }
        if (expressionContext.BOOLEAN() != null) {
            return new BooleanValue(expressionContext.BOOLEAN().getText().equals("true"));
        }
        if (expressionContext.VOID() != null) {
            return Void.INSTANCE;
        }
        if (expressionContext.EMPTY() != null) {
            return Empty.INSTANCE;
        }
        if (expressionContext.GREEDY() != null) {
            return Greedy.INSTANCE;
        }
        lispParser.CallContext call = expressionContext.call();
        if (call != null) {
            return LispUtils.visitCall(call, inMacro);
        }
        lispParser.MacroCallContext macroCall = expressionContext.macroCall();
        if (macroCall != null) {
            return LispUtils.visitMacroCall(macroCall, inMacro);
        }
        lispParser.ListContext list = expressionContext.list();
        if (list != null) {
            return LispUtils.visitList(list, inMacro);
        }
        lispParser.MapContext map = expressionContext.map();
        if (map != null) {
            return LispUtils.visitMap(map, inMacro);
        }
        return null;
    }

    private static void throwAtToken(ParserRuleContext scope, String message) {
        int line = scope.start.getLine();
        int charPositionInLine = scope.start.getCharPositionInLine();
        String msg = String.format("error at %d:%d: %s\nin '%s'", line, charPositionInLine, message, scope.children.stream().map(ParseTree::getText).collect(Collectors.joining(" ")));
        throw new ParseError(msg);
    }

    private static void checkForGreedy(ParserRuleContext scope, List<SExpression> scopeElements) {
        if (scopeElements.stream().filter(e -> e instanceof Greedy).count() > 1L) {
            LispUtils.throwAtToken(scope, "More than one greedy argument operator in scope");
        }
    }

    public static Call visitCall(lispParser.CallContext callContext, boolean inMacro) {
        SExpression subject = LispUtils.visitSExpression(callContext.subject, inMacro);
        List<SExpression> args = callContext.sExpression().stream().skip(1L).map(c -> LispUtils.visitSExpression(c, inMacro)).toList();
        if (subject instanceof Greedy) {
            LispUtils.throwAtToken(callContext.subject, "Greedy argument operator cannot be the subject of the call");
        }
        LispUtils.checkForGreedy(callContext, args);
        return new Call(subject, args);
    }

    public static MacroCall visitMacroCall(lispParser.MacroCallContext callContext, boolean inMacro) {
        List<SExpression> args = callContext.sExpression().stream().map(c -> LispUtils.visitSExpression(c, inMacro)).toList();
        LispUtils.checkForGreedy(callContext, args);
        return new MacroCall(callContext.name.getText(), args);
    }

    public static ExpressionList visitList(lispParser.ListContext listContext, boolean inMacro) {
        List<SExpression> list = listContext.sExpression().stream().map(c -> LispUtils.visitSExpression(c, inMacro)).toList();
        LispUtils.checkForGreedy(listContext, list);
        return new ExpressionList(list);
    }

    private static SExpression yellAtGreedy(ParserRuleContext context, SExpression expression) {
        if (expression instanceof Greedy) {
            LispUtils.throwAtToken(context, "Greedy argument operator cannot be used as keys or values of a map");
        }
        return expression;
    }

    public static MapExpression visitMap(lispParser.MapContext mapContext, boolean inMacro) {
        HashMap<SExpression, SExpression> map = new HashMap<SExpression, SExpression>();
        mapContext.mapEntry().forEach(entry -> map.put(LispUtils.yellAtGreedy(entry.key, LispUtils.visitSExpression(entry.key, inMacro)), LispUtils.yellAtGreedy(entry.value, LispUtils.visitSExpression(entry.value, inMacro))));
        return new MapExpression(map);
    }

    private static class ErrorListerer
    implements ANTLRErrorListener {
        private ParseError error;

        private ErrorListerer() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            Object errorMessage = String.format("error at %d:%d: %s", line, charPositionInLine, msg);
            Token symbol = (Token)offendingSymbol;
            if (symbol.getText().equals("<EOF>")) {
                errorMessage = (String)errorMessage + ". Have you forgot to close bracket?";
            }
            this.error = new ParseError((String)errorMessage);
        }

        public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        }

        public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        }

        public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        }

        public void throwExceptionIfNeeded() {
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    public static class ParseError
    extends RuntimeException {
        public ParseError(String message) {
            super(message);
        }
    }
}

