/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.thejebforge.trickster_lisp.transpiler.ast.BooleanValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Call;
import com.thejebforge.trickster_lisp.transpiler.ast.DoubleValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Empty;
import com.thejebforge.trickster_lisp.transpiler.ast.ExpressionList;
import com.thejebforge.trickster_lisp.transpiler.ast.Greedy;
import com.thejebforge.trickster_lisp.transpiler.ast.Identifier;
import com.thejebforge.trickster_lisp.transpiler.ast.IntegerValue;
import com.thejebforge.trickster_lisp.transpiler.ast.Macro;
import com.thejebforge.trickster_lisp.transpiler.ast.MacroCall;
import com.thejebforge.trickster_lisp.transpiler.ast.MapExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.Operator;
import com.thejebforge.trickster_lisp.transpiler.ast.PreProcessor;
import com.thejebforge.trickster_lisp.transpiler.ast.Root;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.Void;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.CallBuilder;
import com.thejebforge.trickster_lisp.transpiler.ast.builder.RootBuilder;
import com.thejebforge.trickster_lisp.transpiler.fragment.ASTToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.ArgToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.BlockTypeToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.BooleanToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.CustomFragmentToAST;
import com.thejebforge.trickster_lisp.transpiler.fragment.DimensionToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.EmptyToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.EntityToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.EntityTypeToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.FragmentToAST;
import com.thejebforge.trickster_lisp.transpiler.fragment.GetGlyphToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.GreedyToException;
import com.thejebforge.trickster_lisp.transpiler.fragment.ItemTypeToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.ListToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.MacroCallToException;
import com.thejebforge.trickster_lisp.transpiler.fragment.MapToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.NumberToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.PatternLiteralToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.PatternToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.SlotToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.TypeToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.VectorToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.VoidToFragment;
import com.thejebforge.trickster_lisp.transpiler.fragment.ZalgoToFragment;
import com.thejebforge.trickster_lisp.transpiler.util.CallUtils;
import dev.enjarai.trickster.spell.Fragment;
import dev.enjarai.trickster.spell.Pattern;
import dev.enjarai.trickster.spell.PatternGlyph;
import dev.enjarai.trickster.spell.SpellPart;
import dev.enjarai.trickster.spell.fragment.FragmentType;
import dev.enjarai.trickster.spell.fragment.VoidFragment;
import dev.enjarai.trickster.spell.trick.Trick;
import dev.enjarai.trickster.spell.trick.Tricks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public abstract class SpellConverter {
    public static final BiMap<String, String> OPERATOR_MAPPING = HashBiMap.create();
    public static final String LOAD_ARGUMENT_PART = "load_argument_";
    public static final Set<String> FRAGMENT_IDS;
    public static final Map<String, ASTToFragment> CALL_ID_CONVERTERS;
    public static final Map<Class<?>, ASTToFragment> PRIMITIVE_CONVERTERS;
    public static Map<FragmentType<?>, CustomFragmentToAST> CUSTOM_FRAGMENT_CONVERTERS;

    private static String getTrickId(Trick<?> trick) {
        return Objects.requireNonNull(Tricks.REGISTRY.method_10221(trick)).method_12832();
    }

    public static SExpression wrapExpressionIfNeeded(Fragment spell) {
        SExpression expression = SpellConverter.fragmentToExpression(spell);
        if (spell instanceof SpellPart) {
            if (expression instanceof Call) {
                Identifier id;
                Call call = (Call)expression;
                SExpression sExpression = call.getSubject();
                if (sExpression instanceof Identifier && FRAGMENT_IDS.contains((id = (Identifier)sExpression).getName())) {
                    return CallBuilder.builder(expression).build();
                }
                return expression;
            }
            return CallBuilder.builder(expression).build();
        }
        return expression;
    }

    public static Root spellToAST(Fragment spell, List<Macro> savedMacros, List<Macro> macros) {
        return RootBuilder.builder().add(SpellConverter.wrapExpressionIfNeeded(spell)).build().reverseMacros(Stream.concat(macros.stream(), savedMacros.stream()).toList()).appendMacros(savedMacros).simplifyRoot();
    }

    public static SExpression fragmentToExpression(Fragment frag) {
        return SpellConverter.fragmentToExpression(frag, false);
    }

    public static SExpression fragmentToExpression(Fragment frag, boolean preserveSpellParts) {
        try {
            FragmentToAST toAST;
            Optional<SExpression> potentialAST;
            if (frag instanceof FragmentToAST && (potentialAST = (toAST = (FragmentToAST)frag).trickster_lisp$convert(preserveSpellParts)).isPresent()) {
                return potentialAST.get();
            }
        }
        catch (ClassCastException toAST) {
            // empty catch block
        }
        FragmentType ty = frag.type();
        if (CUSTOM_FRAGMENT_CONVERTERS.containsKey(ty)) {
            CustomFragmentToAST converter = CUSTOM_FRAGMENT_CONVERTERS.get(ty);
            return converter.apply(frag);
        }
        throw new IllegalArgumentException("Unknown fragment type: " + frag.getClass().getName());
    }

    public static boolean isIdentifierValid(Identifier id) {
        String[] splits = id.getName().split(":");
        class_2960 trick_id = splits.length > 1 ? class_2960.method_60655((String)splits[0], (String)splits[1]) : class_2960.method_60655((String)"trickster", (String)splits[0]);
        return CALL_ID_CONVERTERS.containsKey(id.getName()) || Tricks.REGISTRY.method_10250(trick_id);
    }

    public static boolean isOperatorValid(Operator op) {
        return OPERATOR_MAPPING.containsValue((Object)op.getType());
    }

    private static Pattern idToTrickPattern(SExpression parent, Identifier id) {
        String[] split = id.getName().split(":");
        class_2960 trickId = split.length > 1 ? class_2960.method_60655((String)split[0], (String)split[1]) : class_2960.method_60655((String)"trickster", (String)split[0]);
        Trick trick = (Trick)Tricks.REGISTRY.method_10223(trickId);
        if (trick == null) {
            throw CallUtils.getConversionError(parent, "Unknown trick");
        }
        return trick.getPattern();
    }

    public static Fragment expressionToFragment(SExpression expr) {
        ASTToFragment converter;
        SExpression sExpression;
        Call call;
        SExpression sExpression2;
        if (expr instanceof Call && (sExpression2 = (call = (Call)expr).getSubject()) instanceof Operator) {
            Operator op = (Operator)sExpression2;
            String mappedOperator = (String)OPERATOR_MAPPING.inverse().get((Object)op.getType());
            if (mappedOperator == null) {
                throw CallUtils.getConversionError(op, "Unknown operator");
            }
            CallBuilder callBuilder = CallBuilder.builder(mappedOperator);
            call.getArguments().forEach(callBuilder::add);
            expr = callBuilder.build();
        }
        if (expr instanceof Call && (sExpression = (call = (Call)expr).getSubject()) instanceof Identifier) {
            Identifier callId = (Identifier)sExpression;
            if (CALL_ID_CONVERTERS.containsKey(callId.getName())) {
                converter = CALL_ID_CONVERTERS.get(callId.getName());
                return converter.apply(call);
            }
            return new SpellPart((Fragment)new PatternGlyph(SpellConverter.idToTrickPattern(call, callId)), call.getArguments().stream().map(SpellConverter::expressionToFragment).map(SpellConverter::wrap).toList());
        }
        if (PRIMITIVE_CONVERTERS.containsKey(expr.getClass())) {
            converter = PRIMITIVE_CONVERTERS.get(expr.getClass());
            return converter.apply(expr);
        }
        if (expr instanceof Identifier) {
            Identifier id = (Identifier)expr;
            return new SpellPart((Fragment)new PatternGlyph(SpellConverter.idToTrickPattern(expr, id)));
        }
        if (expr instanceof Operator) {
            Operator op = (Operator)expr;
            Identifier underlyingId = new Identifier((String)OPERATOR_MAPPING.inverse().get((Object)op.getType()));
            return new SpellPart((Fragment)new PatternGlyph(SpellConverter.idToTrickPattern(expr, underlyingId)));
        }
        if (expr instanceof Call) {
            Call call2 = (Call)expr;
            return new SpellPart(SpellConverter.expressionToFragment(call2.getSubject()), call2.getArguments().stream().map(SpellConverter::expressionToFragment).map(SpellConverter::wrap).toList());
        }
        throw CallUtils.getConversionError(expr, "Couldn't convert expression to fragment");
    }

    public static SpellPart wrap(Fragment fragment) {
        if (!(fragment instanceof SpellPart)) {
            return new SpellPart(fragment);
        }
        return (SpellPart)fragment;
    }

    public static Fragment astToFinalFragment(Root root, List<Macro> macros) {
        if ((root = root.runPreProcessors(macros.stream().map(PreProcessor.class::cast).toList()).runPreProcessors()).expressions().isEmpty()) {
            return new VoidFragment();
        }
        if (root.expressions().size() == 1) {
            SExpression expression = root.expressions().getFirst();
            return SpellConverter.expressionToFragment(expression);
        }
        return new SpellPart((Fragment)new PatternGlyph(), root.expressions().stream().map(SpellConverter::expressionToFragment).map(SpellConverter::wrap).toList());
    }

    static {
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.ADD), (Object)"+");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.SUBTRACT), (Object)"-");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.MULTIPLY), (Object)"*");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.DIVIDE), (Object)"/");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.MODULO), (Object)"%");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.IF_ELSE), (Object)"?");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.EQUALS), (Object)"==");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.NOT_EQUALS), (Object)"!=");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.GREATER_THAN), (Object)">");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.LESSER_THAN), (Object)"<");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.ALL), (Object)"&");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.ANY), (Object)"|");
        OPERATOR_MAPPING.put((Object)SpellConverter.getTrickId(Tricks.NONE), (Object)"!|");
        FRAGMENT_IDS = new HashSet<String>(){
            {
                this.add("block_type");
                this.add("dimension");
                this.add("entity");
                this.add("entity_type");
                this.add("item_type");
                this.add("slot");
                this.add("pattern");
                this.add("pattern_literal");
                this.add("type");
                this.add("vec");
                this.add("void");
                this.add("zalgo");
            }
        };
        CALL_ID_CONVERTERS = new HashMap<String, ASTToFragment>(){
            {
                this.put("block_type", new BlockTypeToFragment());
                this.put("dimension", new DimensionToFragment());
                this.put("entity", new EntityToFragment());
                this.put("entity_type", new EntityTypeToFragment());
                this.put("item_type", new ItemTypeToFragment());
                this.put("slot", new SlotToFragment());
                this.put("pattern", new PatternToFragment());
                this.put("pattern_literal", new PatternLiteralToFragment());
                this.put("type", new TypeToFragment());
                this.put("vec", new VectorToFragment());
                this.put("void", new VoidToFragment());
                this.put("zalgo", new ZalgoToFragment());
                this.put("arg", new ArgToFragment());
                this.put("get_glyph", new GetGlyphToFragment());
            }
        };
        PRIMITIVE_CONVERTERS = new HashMap<Class<?>, ASTToFragment>(){
            {
                this.put(IntegerValue.class, new NumberToFragment());
                this.put(DoubleValue.class, new NumberToFragment());
                this.put(BooleanValue.class, new BooleanToFragment());
                this.put(ExpressionList.class, new ListToFragment());
                this.put(MapExpression.class, new MapToFragment());
                this.put(Void.class, new VoidToFragment());
                this.put(Empty.class, new EmptyToFragment());
                this.put(Greedy.class, new GreedyToException());
                this.put(MacroCall.class, new MacroCallToException());
            }
        };
        CUSTOM_FRAGMENT_CONVERTERS = new HashMap();
    }
}

