/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Objects;

public class Call
extends SExpression {
    public static final StructEndec<Call> ENDEC = StructEndecBuilder.of((StructField)SExpression.ENDEC.fieldOf("id", Call::getSubject), (StructField)SExpression.ENDEC.listOf().fieldOf("args", Call::getArguments), Call::new);
    private SExpression subject;
    private List<SExpression> arguments;

    public Call(SExpression subject, List<SExpression> arguments) {
        this.subject = subject;
        this.arguments = arguments;
    }

    public SExpression getSubject() {
        return this.subject;
    }

    public void setSubject(SExpression subject) {
        this.subject = subject;
    }

    public List<SExpression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<SExpression> arguments) {
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Call)) {
            return false;
        }
        Call call = (Call)o;
        return Objects.equals(this.subject, call.subject) && Objects.equals(this.arguments, call.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.arguments);
    }

    public String toString() {
        return "Call{\nsubject='" + String.valueOf(this.subject) + "', \narguments=" + String.valueOf(this.arguments) + "\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.CALL;
    }

    @Override
    public SExpression deepCopy() {
        return new Call(this.subject.deepCopy(), this.arguments.stream().map(SExpression::deepCopy).toList());
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return other instanceof Call;
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.toCallCode(indent, tabSize, inline, this.subject.toCode(indent + tabSize, tabSize, true), this.arguments);
    }
}

