/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.Objects;

public class DoubleValue
extends SExpression {
    public static final StructEndec<DoubleValue> ENDEC = StructEndecBuilder.of((StructField)StructEndec.DOUBLE.fieldOf("v", DoubleValue::getNumber), DoubleValue::new);
    private double number;

    public DoubleValue(double number) {
        this.number = number;
    }

    public double getNumber() {
        return this.number;
    }

    public void setNumber(double number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleValue)) {
            return false;
        }
        DoubleValue that = (DoubleValue)o;
        return Double.compare(this.number, that.number) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.number);
    }

    public String toString() {
        return "Double{\nnumber=" + this.number + "\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.DOUBLE;
    }

    @Override
    public SExpression deepCopy() {
        return new DoubleValue(this.number);
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return this.equals(other);
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        return LispUtils.addIndent(indent, inline) + this.number;
    }
}

