/*
 * Decompiled with CFR 0.152.
 */
package com.thejebforge.trickster_lisp.transpiler.ast;

import com.thejebforge.trickster_lisp.transpiler.LispUtils;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpression;
import com.thejebforge.trickster_lisp.transpiler.ast.SExpressionType;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExpressionList
extends SExpression {
    public static final StructEndec<ExpressionList> ENDEC = StructEndecBuilder.of((StructField)SExpression.ENDEC.listOf().fieldOf("list", ExpressionList::getExpressions), ExpressionList::new);
    private List<SExpression> expressions;

    public ExpressionList(List<SExpression> expressions) {
        this.expressions = expressions;
    }

    public List<SExpression> getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List<SExpression> expressions) {
        this.expressions = expressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionList)) {
            return false;
        }
        ExpressionList that = (ExpressionList)o;
        return Objects.equals(this.expressions, that.expressions);
    }

    public int hashCode() {
        return Objects.hashCode(this.expressions);
    }

    public String toString() {
        return "ExpressionList{\nexpressions=" + String.valueOf(this.expressions) + "\n}";
    }

    @Override
    public SExpressionType<?> type() {
        return SExpressionType.LIST;
    }

    @Override
    public SExpression deepCopy() {
        return new ExpressionList(this.expressions.stream().map(SExpression::deepCopy).toList());
    }

    @Override
    public boolean shallowEquals(SExpression other) {
        return other instanceof ExpressionList;
    }

    @Override
    public String toCode(int indent, int tabSize, boolean inline) {
        if (this.expressions.isEmpty()) {
            return LispUtils.addIndent(indent, inline) + "[]";
        }
        return LispUtils.addIndent(indent, inline) + "[" + String.valueOf(this.expressions.size() == 1 ? "" : Character.valueOf('\n')) + this.expressions.stream().map(e -> e.toCode(indent + tabSize, tabSize, this.expressions.size() == 1)).collect(Collectors.joining(",\n")) + "]";
    }
}

